/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.common.utils.AssertUtils;
import org.apache.eventmesh.common.utils.IPUtils;

public class CommonConfiguration {
    private transient String eventMeshEnv = "P";
    private transient String eventMeshIDC = "FT";
    private transient String eventMeshCluster = "LS";
    private transient String eventMeshName = "";
    private transient List<String> eventMeshProvideServerProtocols;
    private transient String sysID = "5477";
    private transient String eventMeshConnectorPluginType = "rocketmq";
    private transient String eventMeshSecurityPluginType = "security";
    private transient String eventMeshRegistryPluginType = "namesrv";
    private transient List<String> eventMeshMetricsPluginType;
    private transient String eventMeshTracePluginType;
    private transient String namesrvAddr = "";
    private transient String eventMeshRegistryPluginUsername = "";
    private transient String eventMeshRegistryPluginPassword = "";
    private transient Integer eventMeshRegisterIntervalInMills = 10000;
    private transient Integer eventMeshFetchRegistryAddrInterval = 10000;
    private transient String eventMeshServerIp = null;
    private transient boolean eventMeshServerSecurityEnable = false;
    private transient boolean eventMeshServerRegistryEnable = false;
    private transient boolean eventMeshServerTraceEnable = false;
    protected transient ConfigurationWrapper configurationWrapper;
    private transient String eventMeshWebhookOrigin = "eventmesh." + this.eventMeshIDC;

    public CommonConfiguration(ConfigurationWrapper configurationWrapper) {
        this.configurationWrapper = configurationWrapper;
    }

    public String getMeshGroup() {
        return String.join((CharSequence)"-", this.eventMeshEnv, this.eventMeshCluster, this.sysID);
    }

    public void init() {
        if (this.configurationWrapper != null) {
            this.eventMeshEnv = this.checkNotEmpty("eventMesh.server.env");
            this.sysID = this.checkNumeric("eventMesh.sysid");
            this.eventMeshCluster = this.checkNotEmpty("eventMesh.server.cluster");
            this.eventMeshName = this.checkNotEmpty("eventMesh.server.name");
            this.eventMeshIDC = this.checkNotEmpty("eventMesh.server.idc");
            this.eventMeshServerIp = this.get("eventMesh.server.hostIp", IPUtils::getLocalAddress);
            this.eventMeshConnectorPluginType = this.checkNotEmpty("eventMesh.connector.plugin.type");
            this.eventMeshServerSecurityEnable = Boolean.parseBoolean(this.get("eventMesh.server.security.enabled", () -> "false"));
            this.eventMeshSecurityPluginType = this.checkNotEmpty("eventMesh.security.plugin.type");
            this.eventMeshServerRegistryEnable = Boolean.parseBoolean(this.get("eventMesh.registry.plugin.enabled", () -> "false"));
            this.eventMeshRegistryPluginType = this.checkNotEmpty("eventMesh.registry.plugin.type");
            this.namesrvAddr = this.checkNotEmpty("eventMesh.registry.plugin.server-addr");
            this.eventMeshRegistryPluginUsername = this.configurationWrapper.getProp("eventMesh.registry.plugin.username", "");
            this.eventMeshRegistryPluginPassword = this.configurationWrapper.getProp("eventMesh.registry.plugin.password", "");
            String metricsPluginType = this.configurationWrapper.getProp("eventMesh.metrics.plugin");
            if (StringUtils.isNotEmpty((CharSequence)metricsPluginType)) {
                this.eventMeshMetricsPluginType = Arrays.stream(metricsPluginType.split(",")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
            }
            this.eventMeshProvideServerProtocols = this.getProvideServerProtocols();
            this.eventMeshServerTraceEnable = Boolean.parseBoolean(this.get("eventMesh.server.trace.enabled", () -> "false"));
            if (this.eventMeshServerTraceEnable) {
                this.eventMeshTracePluginType = this.checkNotEmpty("eventMesh.trace.plugin");
            }
        }
    }

    private String checkNotEmpty(String key) {
        String value = this.configurationWrapper.getProp(key);
        if (value != null) {
            value = StringUtils.deleteWhitespace((String)value);
        }
        AssertUtils.notBlack(value, key + " is invalidated");
        return value;
    }

    private String checkNumeric(String key) {
        String value = this.configurationWrapper.getProp(key);
        if (value != null) {
            value = StringUtils.deleteWhitespace((String)value);
        }
        Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)value) && StringUtils.isNumeric((CharSequence)value) ? 1 : 0) != 0, (Object)(key + " is invalidated"));
        return value;
    }

    private String get(String key, Supplier<String> defaultValueSupplier) {
        String value = this.configurationWrapper.getProp(key);
        if (value != null) {
            value = StringUtils.deleteWhitespace((String)value);
        }
        return StringUtils.isEmpty((CharSequence)value) ? defaultValueSupplier.get() : value;
    }

    public List<String> getProvideServerProtocols() {
        String provideProtocols = this.configurationWrapper.getProp("eventMesh.server.provide.protocols");
        if (StringUtils.isNotEmpty((CharSequence)provideProtocols)) {
            return Arrays.stream(provideProtocols.split(",")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
        }
        return Collections.singletonList("HTTP");
    }

    public String getEventMeshEnv() {
        return this.eventMeshEnv;
    }

    public String getEventMeshIDC() {
        return this.eventMeshIDC;
    }

    public String getEventMeshCluster() {
        return this.eventMeshCluster;
    }

    public String getEventMeshName() {
        return this.eventMeshName;
    }

    public List<String> getEventMeshProvideServerProtocols() {
        return this.eventMeshProvideServerProtocols;
    }

    public String getSysID() {
        return this.sysID;
    }

    public String getEventMeshConnectorPluginType() {
        return this.eventMeshConnectorPluginType;
    }

    public String getEventMeshSecurityPluginType() {
        return this.eventMeshSecurityPluginType;
    }

    public String getEventMeshRegistryPluginType() {
        return this.eventMeshRegistryPluginType;
    }

    public List<String> getEventMeshMetricsPluginType() {
        return this.eventMeshMetricsPluginType;
    }

    public String getEventMeshTracePluginType() {
        return this.eventMeshTracePluginType;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public String getEventMeshRegistryPluginUsername() {
        return this.eventMeshRegistryPluginUsername;
    }

    public String getEventMeshRegistryPluginPassword() {
        return this.eventMeshRegistryPluginPassword;
    }

    public Integer getEventMeshRegisterIntervalInMills() {
        return this.eventMeshRegisterIntervalInMills;
    }

    public Integer getEventMeshFetchRegistryAddrInterval() {
        return this.eventMeshFetchRegistryAddrInterval;
    }

    public String getEventMeshServerIp() {
        return this.eventMeshServerIp;
    }

    public boolean isEventMeshServerSecurityEnable() {
        return this.eventMeshServerSecurityEnable;
    }

    public boolean isEventMeshServerRegistryEnable() {
        return this.eventMeshServerRegistryEnable;
    }

    public boolean isEventMeshServerTraceEnable() {
        return this.eventMeshServerTraceEnable;
    }

    public ConfigurationWrapper getConfigurationWrapper() {
        return this.configurationWrapper;
    }

    public String getEventMeshWebhookOrigin() {
        return this.eventMeshWebhookOrigin;
    }

    public void setEventMeshEnv(String eventMeshEnv) {
        this.eventMeshEnv = eventMeshEnv;
    }

    public void setEventMeshIDC(String eventMeshIDC) {
        this.eventMeshIDC = eventMeshIDC;
    }

    public void setEventMeshCluster(String eventMeshCluster) {
        this.eventMeshCluster = eventMeshCluster;
    }

    public void setEventMeshName(String eventMeshName) {
        this.eventMeshName = eventMeshName;
    }

    public void setEventMeshProvideServerProtocols(List<String> eventMeshProvideServerProtocols) {
        this.eventMeshProvideServerProtocols = eventMeshProvideServerProtocols;
    }

    public void setSysID(String sysID) {
        this.sysID = sysID;
    }

    public void setEventMeshConnectorPluginType(String eventMeshConnectorPluginType) {
        this.eventMeshConnectorPluginType = eventMeshConnectorPluginType;
    }

    public void setEventMeshSecurityPluginType(String eventMeshSecurityPluginType) {
        this.eventMeshSecurityPluginType = eventMeshSecurityPluginType;
    }

    public void setEventMeshRegistryPluginType(String eventMeshRegistryPluginType) {
        this.eventMeshRegistryPluginType = eventMeshRegistryPluginType;
    }

    public void setEventMeshMetricsPluginType(List<String> eventMeshMetricsPluginType) {
        this.eventMeshMetricsPluginType = eventMeshMetricsPluginType;
    }

    public void setEventMeshTracePluginType(String eventMeshTracePluginType) {
        this.eventMeshTracePluginType = eventMeshTracePluginType;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public void setEventMeshRegistryPluginUsername(String eventMeshRegistryPluginUsername) {
        this.eventMeshRegistryPluginUsername = eventMeshRegistryPluginUsername;
    }

    public void setEventMeshRegistryPluginPassword(String eventMeshRegistryPluginPassword) {
        this.eventMeshRegistryPluginPassword = eventMeshRegistryPluginPassword;
    }

    public void setEventMeshRegisterIntervalInMills(Integer eventMeshRegisterIntervalInMills) {
        this.eventMeshRegisterIntervalInMills = eventMeshRegisterIntervalInMills;
    }

    public void setEventMeshFetchRegistryAddrInterval(Integer eventMeshFetchRegistryAddrInterval) {
        this.eventMeshFetchRegistryAddrInterval = eventMeshFetchRegistryAddrInterval;
    }

    public void setEventMeshServerIp(String eventMeshServerIp) {
        this.eventMeshServerIp = eventMeshServerIp;
    }

    public void setEventMeshServerSecurityEnable(boolean eventMeshServerSecurityEnable) {
        this.eventMeshServerSecurityEnable = eventMeshServerSecurityEnable;
    }

    public void setEventMeshServerRegistryEnable(boolean eventMeshServerRegistryEnable) {
        this.eventMeshServerRegistryEnable = eventMeshServerRegistryEnable;
    }

    public void setEventMeshServerTraceEnable(boolean eventMeshServerTraceEnable) {
        this.eventMeshServerTraceEnable = eventMeshServerTraceEnable;
    }

    public void setConfigurationWrapper(ConfigurationWrapper configurationWrapper) {
        this.configurationWrapper = configurationWrapper;
    }

    public void setEventMeshWebhookOrigin(String eventMeshWebhookOrigin) {
        this.eventMeshWebhookOrigin = eventMeshWebhookOrigin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonConfiguration)) {
            return false;
        }
        CommonConfiguration other = (CommonConfiguration)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonConfiguration;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "CommonConfiguration(eventMeshEnv=" + this.getEventMeshEnv() + ", eventMeshIDC=" + this.getEventMeshIDC() + ", eventMeshCluster=" + this.getEventMeshCluster() + ", eventMeshName=" + this.getEventMeshName() + ", eventMeshProvideServerProtocols=" + this.getEventMeshProvideServerProtocols() + ", sysID=" + this.getSysID() + ", eventMeshConnectorPluginType=" + this.getEventMeshConnectorPluginType() + ", eventMeshSecurityPluginType=" + this.getEventMeshSecurityPluginType() + ", eventMeshRegistryPluginType=" + this.getEventMeshRegistryPluginType() + ", eventMeshMetricsPluginType=" + this.getEventMeshMetricsPluginType() + ", eventMeshTracePluginType=" + this.getEventMeshTracePluginType() + ", namesrvAddr=" + this.getNamesrvAddr() + ", eventMeshRegistryPluginUsername=" + this.getEventMeshRegistryPluginUsername() + ", eventMeshRegistryPluginPassword=" + this.getEventMeshRegistryPluginPassword() + ", eventMeshRegisterIntervalInMills=" + this.getEventMeshRegisterIntervalInMills() + ", eventMeshFetchRegistryAddrInterval=" + this.getEventMeshFetchRegistryAddrInterval() + ", eventMeshServerIp=" + this.getEventMeshServerIp() + ", eventMeshServerSecurityEnable=" + this.isEventMeshServerSecurityEnable() + ", eventMeshServerRegistryEnable=" + this.isEventMeshServerRegistryEnable() + ", eventMeshServerTraceEnable=" + this.isEventMeshServerTraceEnable() + ", configurationWrapper=" + this.getConfigurationWrapper() + ", eventMeshWebhookOrigin=" + this.getEventMeshWebhookOrigin() + ")";
    }

    static class ConfKeys {
        public static final String KEYS_EVENTMESH_ENV = "eventMesh.server.env";
        public static final String KEYS_EVENTMESH_IDC = "eventMesh.server.idc";
        public static final String KEYS_EVENTMESH_SYSID = "eventMesh.sysid";
        public static final String KEYS_EVENTMESH_SERVER_CLUSTER = "eventMesh.server.cluster";
        public static final String KEYS_EVENTMESH_SERVER_NAME = "eventMesh.server.name";
        public static final String KEYS_EVENTMESH_SERVER_PROVIDE_PROTOCOLS = "eventMesh.server.provide.protocols";
        public static final String KEYS_EVENTMESH_SERVER_HOST_IP = "eventMesh.server.hostIp";
        public static final String KEYS_EVENTMESH_SERVER_REGISTER_INTERVAL = "eventMesh.server.registry.registerIntervalInMills";
        public static final String KEYS_EVENTMESH_SERVER_FETCH_REGISTRY_ADDR_INTERVAL = "eventMesh.server.registry.fetchRegistryAddrIntervalInMills";
        public static final String KEYS_ENENTMESH_CONNECTOR_PLUGIN_TYPE = "eventMesh.connector.plugin.type";
        public static final String KEYS_EVENTMESH_SECURITY_ENABLED = "eventMesh.server.security.enabled";
        public static final String KEYS_ENENTMESH_SECURITY_PLUGIN_TYPE = "eventMesh.security.plugin.type";
        public static final String KEYS_EVENTMESH_REGISTRY_ENABLED = "eventMesh.registry.plugin.enabled";
        public static final String KEYS_ENENTMESH_REGISTRY_PLUGIN_TYPE = "eventMesh.registry.plugin.type";
        public static final String KEYS_EVENTMESH_REGISTRY_PULGIN_SERVER_ADDR = "eventMesh.registry.plugin.server-addr";
        public static final String KEYS_EVENTMESH_REGISTRY_PULGIN_USERNAME = "eventMesh.registry.plugin.username";
        public static final String KEYS_EVENTMESH_REGISTRY_PULGIN_PASSWORD = "eventMesh.registry.plugin.password";
        public static final String KEYS_EVENTMESH_METRICS_PLUGIN_TYPE = "eventMesh.metrics.plugin";
        public static final String KEYS_EVENTMESH_TRACE_ENABLED = "eventMesh.server.trace.enabled";
        public static final String KEYS_EVENTMESH_TRACE_PLUGIN_TYPE = "eventMesh.trace.plugin";

        ConfKeys() {
        }
    }
}

