/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.internal.DnsNameResolver;
import io.grpc.internal.SharedResourceHolder;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.Executor;

public final class PinpointDnsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "dns";
    private final Executor dnsExecutor;
    private final String name;

    public PinpointDnsNameResolverProvider(String name, Executor dnsExecutor) {
        this.name = Objects.requireNonNull(name, "name");
        this.dnsExecutor = Objects.requireNonNull(dnsExecutor, "dnsExecutorService");
    }

    public DnsNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = (String)Preconditions.checkNotNull((Object)targetUri.getPath(), (Object)"targetPath");
            Preconditions.checkArgument((boolean)targetPath.startsWith("/"), (String)"the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new DnsNameResolver(targetUri.getAuthority(), name, args, this.wrapExecutor(this.dnsExecutor), Stopwatch.createUnstarted(), false);
        }
        return null;
    }

    private SharedResourceHolder.Resource<Executor> wrapExecutor(final Executor executor) {
        return new SharedResourceHolder.Resource<Executor>(){

            public Executor create() {
                return executor;
            }

            public void close(Executor instance) {
            }

            public String toString() {
                return PinpointDnsNameResolverProvider.this.name;
            }
        };
    }

    public String getDefaultScheme() {
        return SCHEME;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 5;
    }
}

