/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.client.interceptor;

import com.navercorp.pinpoint.common.profiler.logging.ThrottledLogger;
import com.navercorp.pinpoint.grpc.client.interceptor.DiscardEventListener;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingDiscardEventListener<ReqT>
implements DiscardEventListener<ReqT> {
    private final ThrottledLogger logger;

    public LoggingDiscardEventListener(String loggerName, long rateLimitCount) {
        Objects.requireNonNull(loggerName, "loggerName");
        Logger log = LogManager.getLogger((String)loggerName);
        this.logger = ThrottledLogger.getLogger((Logger)log, (long)rateLimitCount);
    }

    @Override
    public void onDiscard(ReqT message, String cause) {
        this.logDiscardMessage(message, cause);
    }

    private void logDiscardMessage(ReqT message, String cause) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Discard {} message, {}. discardCount:{}", new Object[]{this.getMessageType(message), cause, this.logger.getCounter() + 1L});
        }
    }

    @Override
    public void onCancel(String message, Throwable throwable) {
        this.logger.info("Cancel message. message={}, cause={}", new Object[]{message, throwable.getMessage(), throwable});
    }

    private String getMessageType(ReqT message) {
        if (message == null) {
            return "null";
        }
        return message.getClass().getSimpleName();
    }

    public long getDiscardCount() {
        return this.logger.getCounter();
    }
}

