/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pulsar.producer;

import io.cloudevents.CloudEvent;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.exception.ConnectorRuntimeException;

public abstract class AbstractProducer {
    protected final AtomicBoolean started = new AtomicBoolean(false);
    final Properties properties;

    AbstractProducer(Properties properties) {
        this.properties = properties;
    }

    public Properties properties() {
        return this.properties;
    }

    ConnectorRuntimeException checkProducerException(CloudEvent cloudEvent, Throwable e) {
        if (cloudEvent.getData() == null) {
            return new ConnectorRuntimeException(String.format("CloudEvent message data does not exist, %s", e.getMessage()));
        }
        return new ConnectorRuntimeException(String.format("Unknown connector runtime exception, %s", e.getMessage()));
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.isStarted();
    }
}

