/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pulsar.consumer;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventDeserializationException;
import io.cloudevents.core.provider.EventFormatProvider;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.api.exception.ConnectorRuntimeException;
import org.apache.eventmesh.connector.pulsar.config.ClientConfiguration;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarConsumerImpl
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(PulsarConsumerImpl.class);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Properties properties;
    private PulsarClient pulsarClient;
    private org.apache.pulsar.client.api.Consumer<byte[]> consumer;
    private EventListener eventListener;

    public void init(Properties properties) throws Exception {
        this.properties = properties;
        ClientConfiguration clientConfiguration = ClientConfiguration.getInstance();
        try {
            ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(clientConfiguration.getServiceAddr());
            if (clientConfiguration.getAuthPlugin() != null) {
                Preconditions.checkNotNull((Object)clientConfiguration.getAuthParams(), (Object)"Authentication Enabled in pulsar cluster, Please set authParams in pulsar-client.properties");
                clientBuilder.authentication(clientConfiguration.getAuthPlugin(), clientConfiguration.getAuthParams());
            }
            this.pulsarClient = clientBuilder.build();
        }
        catch (Exception ex) {
            throw new ConnectorRuntimeException(String.format("Failed to connect pulsar with exception: %", ex.getMessage()));
        }
    }

    public void start() {
        this.started.compareAndSet(false, true);
    }

    public void subscribe(final String topic) throws Exception {
        if (this.pulsarClient == null) {
            throw new ConnectorRuntimeException(String.format("Cann't find the pulsar client for topic: %s", topic));
        }
        EventMeshAsyncConsumeContext consumeContext = new EventMeshAsyncConsumeContext(){

            public void commit(EventMeshAction action) {
                log.debug("message action: {} for topic: {}", (Object)action.name(), (Object)topic);
            }
        };
        this.consumer = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName(this.properties.getProperty("consumerGroup")).messageListener((MessageListener & Serializable)(ackConsumer, msg) -> {
            CloudEvent cloudEvent = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json").deserialize(msg.getData());
            this.eventListener.consume(cloudEvent, (AsyncConsumeContext)consumeContext);
            try {
                ackConsumer.acknowledge(msg);
            }
            catch (PulsarClientException ex) {
                throw new ConnectorRuntimeException(String.format("Failed to unsubscribe the topic:%s with exception: %s", topic, ex.getMessage()));
            }
            catch (EventDeserializationException ex) {
                log.warn("The Message isn't json format, with exception:{}", (Object)ex.getMessage());
            }
        }).subscribe();
    }

    public void unsubscribe(String topic) {
        try {
            this.consumer.unsubscribe();
        }
        catch (PulsarClientException ex) {
            throw new ConnectorRuntimeException(String.format("Failed to unsubscribe the topic:%s with exception: %s", topic, ex.getMessage()));
        }
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
    }

    public void registerEventListener(EventListener listener) {
        this.eventListener = listener;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public void shutdown() {
        this.started.compareAndSet(true, false);
        try {
            this.consumer.close();
            this.pulsarClient.close();
        }
        catch (PulsarClientException ex) {
            throw new ConnectorRuntimeException(String.format("Failed to close the pulsar client with exception: %s", ex.getMessage()));
        }
    }
}

