/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pulsar.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationWrapper {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationWrapper.class);
    private static final Properties properties = new Properties();

    public static String getProp(String key) {
        return StringUtils.isEmpty((CharSequence)key) ? null : properties.getProperty(key, null);
    }

    private static void loadProperties() {
        try (InputStream resourceAsStream = ConfigurationWrapper.class.getResourceAsStream("/pulsar-client.properties");){
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            log.error("Load {}.properties file from classpath error", (Object)"pulsar-client.properties", (Object)e);
            throw new RuntimeException(String.format("Load %s.properties file from classpath error", "pulsar-client.properties"));
        }
        try {
            String configPath = Constants.EVENTMESH_CONF_HOME + File.separator + "pulsar-client.properties";
            if (new File(configPath).exists()) {
                properties.load(new BufferedReader(new FileReader(configPath)));
            }
        }
        catch (IOException e) {
            log.error("Cannot load {} file from conf.", (Object)"pulsar-client.properties", (Object)e);
            throw new IllegalArgumentException(String.format("Cannot load %s file from conf", "pulsar-client.properties"));
        }
    }

    private ConfigurationWrapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        ConfigurationWrapper.loadProperties();
    }
}

