/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pulsar.config;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.connector.pulsar.config.ConfigurationWrapper;

public class ClientConfiguration {
    private String serviceAddr;
    private String authPlugin;
    private String authParams;
    private static ClientConfiguration INSTANCE = null;

    public void init() {
        String serviceAddrStr = ConfigurationWrapper.getProp("eventMesh.server.pulsar.service");
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)serviceAddrStr), (Object)String.format("%s error", "eventMesh.server.pulsar.service"));
        this.serviceAddr = StringUtils.trim((String)serviceAddrStr);
        this.authPlugin = ConfigurationWrapper.getProp("eventMesh.server.pulsar.authPlugin");
        this.authParams = ConfigurationWrapper.getProp("eventMesh.server.pulsar.authParams");
    }

    public static ClientConfiguration getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClientConfiguration();
            INSTANCE.init();
        }
        return INSTANCE;
    }

    public String getServiceAddr() {
        return this.serviceAddr;
    }

    public String getAuthPlugin() {
        return this.authPlugin;
    }

    public String getAuthParams() {
        return this.authParams;
    }

    public void setServiceAddr(String serviceAddr) {
        this.serviceAddr = serviceAddr;
    }

    public void setAuthPlugin(String authPlugin) {
        this.authPlugin = authPlugin;
    }

    public void setAuthParams(String authParams) {
        this.authParams = authParams;
    }

    static class ConfKeys {
        public static final String KEYS_EVENTMESH_PULSAR_SERVICE_ADDR = "eventMesh.server.pulsar.service";
        public static final String KEYS_EVENTMESH_PULSAR_AUTH_PLUGIN = "eventMesh.server.pulsar.authPlugin";
        public static final String KEYS_EVENTMESH_PULSAR_AUTH_PARAMS = "eventMesh.server.pulsar.authParams";

        ConfKeys() {
        }
    }
}

