/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.impl.eventmeshmessage;

import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.client.tcp.EventMeshTCPPubClient;
import org.apache.eventmesh.client.tcp.common.AsyncRRCallback;
import org.apache.eventmesh.client.tcp.common.MessageUtils;
import org.apache.eventmesh.client.tcp.common.ReceiveMsgHook;
import org.apache.eventmesh.client.tcp.common.RequestContext;
import org.apache.eventmesh.client.tcp.common.TcpClient;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.client.tcp.impl.AbstractEventMeshTCPPubHandler;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventMeshMessageTCPPubClient
extends TcpClient
implements EventMeshTCPPubClient<EventMeshMessage> {
    private static final Logger log = LoggerFactory.getLogger(EventMeshMessageTCPPubClient.class);
    private transient ReceiveMsgHook<EventMeshMessage> callback;
    private final transient ConcurrentHashMap<String, AsyncRRCallback> callbackConcurrentHashMap = new ConcurrentHashMap();

    public EventMeshMessageTCPPubClient(EventMeshTCPClientConfig eventMeshTcpClientConfig) {
        super(eventMeshTcpClientConfig);
    }

    @Override
    public void init() throws EventMeshException {
        try {
            this.open(new EventMeshTCPPubHandler(this.contexts));
            this.hello();
            this.heartbeat();
        }
        catch (Exception e) {
            throw new EventMeshException("Initialize EventMeshMessageTCPPubClient error", (Throwable)e);
        }
    }

    @Override
    public void reconnect() throws EventMeshException {
        try {
            super.reconnect();
            this.hello();
        }
        catch (Exception e) {
            throw new EventMeshException("reconnect error", (Throwable)e);
        }
    }

    @Override
    public Package rr(EventMeshMessage eventMeshMessage, long timeout) throws EventMeshException {
        try {
            Package msg = MessageUtils.buildPackage(eventMeshMessage, Command.REQUEST_TO_SERVER);
            if (log.isInfoEnabled()) {
                log.info("{}|rr|send|type={}|msg={}", new Object[]{CLIENTNO, msg, msg});
            }
            return this.io(msg, timeout);
        }
        catch (Exception e) {
            throw new EventMeshException("rr error", (Throwable)e);
        }
    }

    @Override
    public void asyncRR(EventMeshMessage eventMeshMessage, AsyncRRCallback callback, long timeout) throws EventMeshException {
        try {
            Package msg = MessageUtils.buildPackage(eventMeshMessage, Command.REQUEST_TO_SERVER);
            super.send(msg);
            this.callbackConcurrentHashMap.put((String)RequestContext.key(msg), callback);
        }
        catch (Exception e) {
            throw new EventMeshException("asyncRR error", (Throwable)e);
        }
    }

    @Override
    public Package publish(EventMeshMessage eventMeshMessage, long timeout) throws EventMeshException {
        try {
            Package msg = MessageUtils.buildPackage(eventMeshMessage, Command.ASYNC_MESSAGE_TO_SERVER);
            log.info("SimplePubClientImpl em message|{}|publish|send|type={}|protocol={}|msg={}", new Object[]{CLIENTNO, msg.getHeader().getCmd(), msg.getHeader().getProperty("protocoltype"), msg});
            return this.io(msg, timeout);
        }
        catch (Exception e) {
            throw new EventMeshException("publish error", (Throwable)e);
        }
    }

    @Override
    public void broadcast(EventMeshMessage eventMeshMessage, long timeout) throws EventMeshException {
        try {
            Package msg = MessageUtils.buildPackage(eventMeshMessage, Command.BROADCAST_MESSAGE_TO_SERVER);
            log.info("{}|publish|send|type={}|protocol={}|msg={}", new Object[]{CLIENTNO, msg.getHeader().getCmd(), msg.getHeader().getProperty("protocoltype"), msg});
            super.send(msg);
        }
        catch (Exception e) {
            throw new EventMeshException("Broadcast message error", (Throwable)e);
        }
    }

    @Override
    public void registerBusiHandler(ReceiveMsgHook<EventMeshMessage> receiveMsgHook) throws EventMeshException {
        this.callback = receiveMsgHook;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception e) {
            log.error("Close EventMeshMessage TCP publish client error", (Throwable)e);
        }
    }

    private class EventMeshTCPPubHandler
    extends AbstractEventMeshTCPPubHandler<EventMeshMessage> {
        public EventMeshTCPPubHandler(ConcurrentHashMap<Object, RequestContext> contexts) {
            super(contexts);
        }

        @Override
        public void callback(EventMeshMessage eventMeshMessage, ChannelHandlerContext ctx) {
            if (EventMeshMessageTCPPubClient.this.callback != null) {
                EventMeshMessageTCPPubClient.this.callback.handle(eventMeshMessage).ifPresent(responseMessage -> ctx.writeAndFlush((Object)MessageUtils.buildPackage(responseMessage, Command.RESPONSE_TO_SERVER)));
            }
        }

        @Override
        public EventMeshMessage getMessage(Package tcpPackage) {
            return (EventMeshMessage)JsonUtils.deserialize((String)tcpPackage.getBody().toString(), EventMeshMessage.class);
        }

        @Override
        public void sendResponse(Package tcpPackage) {
            try {
                EventMeshMessageTCPPubClient.this.send(tcpPackage);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }
}

