/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.common;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.provider.EventFormatProvider;
import io.openmessaging.api.Message;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.Subscription;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.assertj.core.util.Preconditions;

public class MessageUtils {
    private static final int seqLength = 10;

    public static Package hello(UserAgent user) {
        Package msg = new Package();
        msg.setHeader(new Header(Command.HELLO_REQUEST, 0, null, MessageUtils.generateRandomString(10)));
        msg.setBody((Object)user);
        return msg;
    }

    public static Package heartBeat() {
        Package msg = new Package();
        msg.setHeader(new Header(Command.HEARTBEAT_REQUEST, 0, null, MessageUtils.generateRandomString(10)));
        return msg;
    }

    public static Package goodbye() {
        Package msg = new Package();
        msg.setHeader(new Header(Command.CLIENT_GOODBYE_REQUEST, 0, null, MessageUtils.generateRandomString(10)));
        return msg;
    }

    public static Package listen() {
        Package msg = new Package();
        msg.setHeader(new Header(Command.LISTEN_REQUEST, 0, null, MessageUtils.generateRandomString(10)));
        return msg;
    }

    public static Package subscribe(String topic, SubscriptionMode subscriptionMode, SubscriptionType subscriptionType) {
        Package msg = new Package();
        msg.setHeader(new Header(Command.SUBSCRIBE_REQUEST, 0, null, MessageUtils.generateRandomString(10)));
        msg.setBody((Object)MessageUtils.generateSubscription(topic, subscriptionMode, subscriptionType));
        return msg;
    }

    public static Package unsubscribe() {
        Package msg = new Package();
        msg.setHeader(new Header(Command.UNSUBSCRIBE_REQUEST, 0, null, MessageUtils.generateRandomString(10)));
        return msg;
    }

    public static Package asyncMessageAck(Package in) {
        Package msg = new Package();
        msg.setHeader(new Header(Command.ASYNC_MESSAGE_TO_CLIENT_ACK, 0, null, in.getHeader().getSeq()));
        msg.setBody(in.getBody());
        return msg;
    }

    public static Package buildPackage(Object message, Command command) {
        Package msg = new Package();
        msg.setHeader(new Header(command, 0, null, MessageUtils.generateRandomString(10)));
        if (message instanceof CloudEvent) {
            CloudEvent cloudEvent = (CloudEvent)message;
            Preconditions.checkNotNull((Object)cloudEvent.getDataContentType(), (String)"DateContentType cannot be null");
            msg.getHeader().putProperty("protocoltype", (Object)"cloudevents");
            msg.getHeader().putProperty("protocolversion", (Object)cloudEvent.getSpecVersion().toString());
            msg.getHeader().putProperty("protocoldesc", (Object)"tcp");
            byte[] bodyByte = EventFormatProvider.getInstance().resolveFormat(cloudEvent.getDataContentType()).serialize((CloudEvent)message);
            msg.setBody((Object)bodyByte);
        } else if (message instanceof EventMeshMessage) {
            msg.getHeader().putProperty("protocoltype", (Object)"eventmeshmessage");
            msg.getHeader().putProperty("protocolversion", (Object)SpecVersion.V1.toString());
            msg.getHeader().putProperty("protocoldesc", (Object)"tcp");
            msg.setBody(message);
        } else if (message instanceof Message) {
            msg.getHeader().putProperty("protocoltype", (Object)"openmessage");
            msg.getHeader().putProperty("protocolversion", (Object)SpecVersion.V1.toString());
        } else {
            throw new IllegalArgumentException("Unsupported message protocol");
        }
        return msg;
    }

    public static Package broadcastMessageAck(Package in) {
        Package msg = new Package();
        msg.setHeader(new Header(Command.BROADCAST_MESSAGE_TO_CLIENT_ACK, 0, null, in.getHeader().getSeq()));
        msg.setBody(in.getBody());
        return msg;
    }

    public static Package requestToClientAck(Package in) {
        Package msg = new Package();
        msg.setHeader(new Header(Command.REQUEST_TO_CLIENT_ACK, 0, null, in.getHeader().getSeq()));
        msg.setBody(in.getBody());
        return msg;
    }

    public static Package responseToClientAck(Package in) {
        Package msg = new Package();
        msg.setHeader(new Header(Command.RESPONSE_TO_CLIENT_ACK, 0, null, in.getHeader().getSeq()));
        msg.setBody(in.getBody());
        return msg;
    }

    public static UserAgent generateSubClient(UserAgent agent) {
        return UserAgent.builder().env(agent.getEnv()).host(agent.getHost()).password(agent.getPassword()).username(agent.getUsername()).path(agent.getPath()).port(agent.getPort()).subsystem(agent.getSubsystem()).pid(agent.getPid()).version(agent.getVersion()).idc(agent.getIdc()).group(agent.getGroup()).purpose("sub").build();
    }

    public static UserAgent generatePubClient(UserAgent agent) {
        return UserAgent.builder().env(agent.getEnv()).host(agent.getHost()).password(agent.getPassword()).username(agent.getUsername()).path(agent.getPath()).port(agent.getPort()).subsystem(agent.getSubsystem()).pid(agent.getPid()).version(agent.getVersion()).idc(agent.getIdc()).group(agent.getGroup()).purpose("pub").build();
    }

    private static Subscription generateSubscription(String topic, SubscriptionMode subscriptionMode, SubscriptionType subscriptionType) {
        Subscription subscription = new Subscription();
        ArrayList<SubscriptionItem> subscriptionItems = new ArrayList<SubscriptionItem>();
        subscriptionItems.add(new SubscriptionItem(topic, subscriptionMode, subscriptionType));
        subscription.setTopicList(subscriptionItems);
        return subscription;
    }

    private static String generateRandomString(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append((char)ThreadLocalRandom.current().nextInt(48, 57));
        }
        return builder.toString();
    }
}

