/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http;

import java.io.IOException;
import org.apache.eventmesh.client.http.AbstractHttpClient;
import org.apache.eventmesh.client.http.EventMeshRetObj;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.model.RequestParam;
import org.apache.eventmesh.client.http.producer.EventMeshProtocolProducer;
import org.apache.eventmesh.client.http.producer.RRCallback;
import org.apache.eventmesh.client.http.producer.RRCallbackResponseHandlerAdapter;
import org.apache.eventmesh.client.http.util.HttpUtils;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.utils.JsonUtils;

public abstract class AbstractProducerHttpClient<T>
extends AbstractHttpClient
implements EventMeshProtocolProducer<T> {
    public AbstractProducerHttpClient(EventMeshHttpClientConfig eventMeshHttpClientConfig) throws EventMeshException {
        super(eventMeshHttpClientConfig);
    }

    @Override
    public void publish(T t) throws EventMeshException {
        this.validateMessage(t);
        String target = this.selectEventMesh();
        try {
            String response = HttpUtils.post(this.httpClient, target, this.builderPublishRequestParam(t));
            EventMeshRetObj ret = (EventMeshRetObj)JsonUtils.deserialize((String)response, EventMeshRetObj.class);
            if (ret.getRetCode() != EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
                throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
            }
        }
        catch (Exception exception) {
            throw new EventMeshException(String.format("Publish message error, target:%s", target), (Throwable)exception);
        }
    }

    @Override
    public T request(T message, long timeout) throws EventMeshException {
        this.validateMessage(message);
        String target = this.selectEventMesh();
        try {
            String response = HttpUtils.post(this.httpClient, target, this.builderRequestParam(message, timeout));
            EventMeshRetObj ret = (EventMeshRetObj)JsonUtils.deserialize((String)response, EventMeshRetObj.class);
            if (ret.getRetCode() == EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
                return this.transformMessage(ret);
            }
            throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
        }
        catch (Exception e) {
            throw new EventMeshException(String.format("Request message error, target:%s", target), (Throwable)e);
        }
    }

    @Override
    public void request(T message, RRCallback<T> rrCallback, long timeout) throws EventMeshException {
        this.validateMessage(message);
        String target = this.selectEventMesh();
        RRCallbackResponseHandlerAdapter<T> adapter = new RRCallbackResponseHandlerAdapter<T>(message, rrCallback, timeout);
        try {
            HttpUtils.post(this.httpClient, null, target, this.builderRequestParam(message, timeout), adapter);
        }
        catch (IOException e) {
            throw new EventMeshException(String.format("Request message error, target:%s", target), (Throwable)e);
        }
    }

    public abstract RequestParam builderPublishRequestParam(T var1);

    public abstract RequestParam builderRequestParam(T var1, long var2);

    public abstract void validateMessage(T var1);

    public abstract T transformMessage(EventMeshRetObj var1);
}

