/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.grpc.producer;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.util.EventMeshClientUtil;
import org.apache.eventmesh.common.protocol.grpc.protos.BatchMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.PublisherServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.protos.Response;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventProducer {
    private static final Logger logger = LoggerFactory.getLogger(CloudEventProducer.class);
    private static final String PROTOCOL_TYPE = "cloudevents";
    private final EventMeshGrpcClientConfig clientConfig;
    private final PublisherServiceGrpc.PublisherServiceBlockingStub publisherClient;

    public CloudEventProducer(EventMeshGrpcClientConfig clientConfig, PublisherServiceGrpc.PublisherServiceBlockingStub publisherClient) {
        this.clientConfig = clientConfig;
        this.publisherClient = publisherClient;
    }

    public Response publish(List<CloudEvent> events) {
        logger.info("BatchPublish message, batch size=" + events.size());
        if (events.size() == 0) {
            return null;
        }
        List enhancedEvents = events.stream().map(event -> this.enhanceCloudEvent((CloudEvent)event, null)).collect(Collectors.toList());
        BatchMessage enhancedMessage = EventMeshClientUtil.buildBatchMessages(enhancedEvents, this.clientConfig, PROTOCOL_TYPE);
        try {
            Response response = this.publisherClient.batchPublish(enhancedMessage);
            logger.info("Received response " + response.toString());
            return response;
        }
        catch (Exception e) {
            logger.error("Error in BatchPublish message {}, error {}", events, (Object)e.getMessage());
            return null;
        }
    }

    public Response publish(CloudEvent cloudEvent) {
        logger.info("Publish message " + cloudEvent.toString());
        CloudEvent enhanceEvent = this.enhanceCloudEvent(cloudEvent, null);
        SimpleMessage enhancedMessage = EventMeshClientUtil.buildSimpleMessage(enhanceEvent, this.clientConfig, PROTOCOL_TYPE);
        try {
            Response response = this.publisherClient.publish(enhancedMessage);
            logger.info("Received response " + response.toString());
            return response;
        }
        catch (Exception e) {
            logger.error("Error in publishing message {}, error {}", (Object)cloudEvent, (Object)e.getMessage());
            return null;
        }
    }

    public CloudEvent requestReply(CloudEvent cloudEvent, int timeout) {
        logger.info("RequestReply message " + cloudEvent.toString());
        CloudEvent enhanceEvent = this.enhanceCloudEvent(cloudEvent, String.valueOf(timeout));
        SimpleMessage enhancedMessage = EventMeshClientUtil.buildSimpleMessage(enhanceEvent, this.clientConfig, PROTOCOL_TYPE);
        try {
            SimpleMessage reply = this.publisherClient.requestReply(enhancedMessage);
            logger.info("Received reply message" + reply.toString());
            Object msg = EventMeshClientUtil.buildMessage(reply, PROTOCOL_TYPE);
            if (msg instanceof CloudEvent) {
                return (CloudEvent)msg;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Error in RequestReply message {}, error {}", (Object)cloudEvent, (Object)e.getMessage());
            return null;
        }
    }

    private CloudEvent enhanceCloudEvent(CloudEvent cloudEvent, String timeout) {
        CloudEventBuilder builder = CloudEventBuilder.from((CloudEvent)cloudEvent).withExtension("env", this.clientConfig.getEnv()).withExtension("idc", this.clientConfig.getIdc()).withExtension("ip", IPUtils.getLocalAddress()).withExtension("pid", Long.toString(ThreadUtils.getPID())).withExtension("sys", this.clientConfig.getSys()).withExtension("language", "JAVA").withExtension("protocoltype", PROTOCOL_TYPE).withExtension("protocoldesc", "grpc").withExtension("protocolversion", cloudEvent.getSpecVersion().toString()).withExtension("uniqueid", RandomStringUtils.generateNum((int)30)).withExtension("seqnum", RandomStringUtils.generateNum((int)30)).withExtension("username", this.clientConfig.getUserName()).withExtension("passwd", this.clientConfig.getPassword()).withExtension("producergroup", this.clientConfig.getProducerGroup());
        if (timeout != null) {
            builder.withExtension("ttl", timeout);
        }
        return builder.build();
    }
}

