/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.grpc.consumer;

import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.consumer.ReceiveMsgHook;
import org.apache.eventmesh.client.grpc.util.EventMeshClientUtil;
import org.apache.eventmesh.common.protocol.grpc.protos.ConsumerServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubStreamHandler<T>
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(SubStreamHandler.class);
    private final CountDownLatch latch = new CountDownLatch(1);
    private final ConsumerServiceGrpc.ConsumerServiceStub consumerAsyncClient;
    private final EventMeshGrpcClientConfig clientConfig;
    private StreamObserver<Subscription> sender;
    private final ReceiveMsgHook<T> listener;

    public SubStreamHandler(ConsumerServiceGrpc.ConsumerServiceStub consumerAsyncClient, EventMeshGrpcClientConfig clientConfig, ReceiveMsgHook<T> listener) {
        this.consumerAsyncClient = consumerAsyncClient;
        this.clientConfig = clientConfig;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSubscription(Subscription subscription) {
        SubStreamHandler subStreamHandler = this;
        synchronized (subStreamHandler) {
            if (this.sender == null) {
                this.sender = this.consumerAsyncClient.subscribeStream(this.createReceiver());
            }
        }
        this.senderOnNext(subscription);
    }

    private StreamObserver<SimpleMessage> createReceiver() {
        return new StreamObserver<SimpleMessage>(){

            public void onNext(SimpleMessage message) {
                Object msg = EventMeshClientUtil.buildMessage(message, SubStreamHandler.this.listener.getProtocolType());
                if (msg instanceof Map) {
                    logger.info("Received message from Server." + message);
                } else {
                    logger.info("Received message from Server.|seq={}|uniqueId={}|", (Object)message.getSeqNum(), (Object)message.getUniqueId());
                    Subscription streamReply = null;
                    try {
                        Optional reply = SubStreamHandler.this.listener.handle(msg);
                        if (reply.isPresent()) {
                            streamReply = SubStreamHandler.this.buildReplyMessage(message, reply.get());
                        }
                    }
                    catch (Throwable t) {
                        logger.error("Error in handling reply message.|seq={}|uniqueId={}|", new Object[]{message.getSeqNum(), message.getUniqueId(), t});
                    }
                    if (streamReply != null) {
                        logger.info("Sending reply message to Server.|seq={}|uniqueId={}|", (Object)streamReply.getReply().getSeqNum(), (Object)streamReply.getReply().getUniqueId());
                        SubStreamHandler.this.senderOnNext(streamReply);
                    }
                }
            }

            public void onError(Throwable t) {
                logger.error("Received Server side error: " + t.getMessage());
                SubStreamHandler.this.close();
            }

            public void onCompleted() {
                logger.info("Finished receiving messages from server.");
                SubStreamHandler.this.close();
            }
        };
    }

    private Subscription buildReplyMessage(SimpleMessage reqMessage, T replyMessage) {
        SimpleMessage simpleMessage = EventMeshClientUtil.buildSimpleMessage(replyMessage, this.clientConfig, this.listener.getProtocolType());
        Subscription.Reply reply = Subscription.Reply.newBuilder().setProducerGroup(this.clientConfig.getConsumerGroup()).setTopic(simpleMessage.getTopic()).setContent(simpleMessage.getContent()).setSeqNum(simpleMessage.getSeqNum()).setUniqueId(simpleMessage.getUniqueId()).setTtl(simpleMessage.getTtl()).putAllProperties(reqMessage.getPropertiesMap()).putAllProperties(simpleMessage.getPropertiesMap()).build();
        return Subscription.newBuilder().setHeader(simpleMessage.getHeader()).setReply(reply).build();
    }

    @Override
    public void run() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            logger.error("SubStreamHandler Thread interrupted." + e.getMessage());
        }
    }

    public void close() {
        if (this.sender != null) {
            this.senderOnComplete();
            this.sender = null;
        }
        this.latch.countDown();
        logger.info("SubStreamHandler closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void senderOnNext(Subscription subscription) {
        try {
            StreamObserver<Subscription> streamObserver = this.sender;
            synchronized (streamObserver) {
                this.sender.onNext((Object)subscription);
            }
        }
        catch (Throwable t) {
            logger.warn("StreamObserver Error onNext {}", (Object)t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void senderOnComplete() {
        try {
            StreamObserver<Subscription> streamObserver = this.sender;
            synchronized (streamObserver) {
                this.sender.onCompleted();
            }
        }
        catch (Throwable t) {
            logger.warn("StreamObserver Error onComplete {}", (Object)t.getMessage());
        }
    }
}

