/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.http;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.body.BaseResponseBody;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.header.BaseResponseHeader;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.utils.JsonUtils;

public class HttpCommand
implements ProtocolTransportObject {
    public static final long serialVersionUID = 4825360350457735498L;
    private static final AtomicLong requestId = new AtomicLong(0L);
    private long opaque;
    private String requestCode;
    public String httpMethod;
    public String httpVersion;
    public Header header;
    public Body body;
    public long reqTime;
    public long resTime;
    public CmdType cmdType = CmdType.REQ;

    public HttpCommand() {
        this(null, null, null);
    }

    public HttpCommand(String httpMethod, String httpVersion, String requestCode) {
        this.httpMethod = httpMethod;
        this.httpVersion = httpVersion;
        this.reqTime = System.currentTimeMillis();
        this.requestCode = requestCode;
        this.opaque = requestId.incrementAndGet();
    }

    public HttpCommand createHttpCommandResponse(Header header, Body body) {
        if (StringUtils.isBlank((CharSequence)this.requestCode)) {
            return null;
        }
        HttpCommand response = new HttpCommand(this.httpMethod, this.httpVersion, this.requestCode);
        response.setOpaque(this.opaque);
        response.setReqTime(this.reqTime);
        response.setHeader(header);
        response.setBody(body);
        response.setCmdType(CmdType.RES);
        response.setResTime(System.currentTimeMillis());
        return response;
    }

    public HttpCommand createHttpCommandResponse(EventMeshRetCode eventMeshRetCode) {
        if (StringUtils.isBlank((CharSequence)this.requestCode)) {
            return null;
        }
        HttpCommand response = new HttpCommand(this.httpMethod, this.httpVersion, this.requestCode);
        response.setOpaque(this.opaque);
        response.setReqTime(this.reqTime);
        BaseResponseHeader baseResponseHeader = new BaseResponseHeader();
        baseResponseHeader.setCode(this.requestCode);
        response.setHeader(baseResponseHeader);
        BaseResponseBody baseResponseBody = new BaseResponseBody();
        baseResponseBody.setRetCode(eventMeshRetCode.getRetCode());
        baseResponseBody.setRetMsg(eventMeshRetCode.getErrMsg());
        response.setBody(baseResponseBody);
        response.setCmdType(CmdType.RES);
        response.setResTime(System.currentTimeMillis());
        return response;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("httpCommand={").append((Object)this.cmdType).append(",").append(this.httpMethod).append("/").append(this.httpVersion).append(",").append("requestCode=").append(this.requestCode).append(",").append("opaque=").append(this.opaque).append(",");
        if (this.cmdType == CmdType.RES) {
            sb.append("cost=").append(this.resTime - this.reqTime).append(",");
        }
        sb.append("header=").append(this.header).append(",").append("body=").append(this.body).append("}");
        return sb.toString();
    }

    public String abstractDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("httpCommand={").append((Object)this.cmdType).append(",").append(this.httpMethod).append("/").append(this.httpVersion).append(",").append("requestCode=").append(this.requestCode).append(",").append("opaque=").append(this.opaque).append(",");
        if (this.cmdType == CmdType.RES) {
            sb.append("cost=").append(this.resTime - this.reqTime).append(",");
        }
        sb.append("header=").append(this.header).append(",").append("bodySize=").append(this.body.toString().length()).append("}");
        return sb.toString();
    }

    public String simpleDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("httpCommand={").append((Object)this.cmdType).append(",").append(this.httpMethod).append("/").append(this.httpVersion).append(",").append("requestCode=").append(this.requestCode).append("}");
        return sb.toString();
    }

    public DefaultFullHttpResponse httpResponse() throws Exception {
        if (this.cmdType == CmdType.REQ) {
            return null;
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])Objects.requireNonNull(JsonUtils.serialize(this.getBody())).getBytes(Constants.DEFAULT_CHARSET)));
        HttpHeaders headers = response.headers();
        headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)("text/plain; charset=" + Constants.DEFAULT_CHARSET));
        headers.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        headers.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        Optional.of(this.getHeader().toMap()).ifPresent(customerHeader -> customerHeader.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1)));
        return response;
    }

    public long getOpaque() {
        return this.opaque;
    }

    public String getRequestCode() {
        return this.requestCode;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public Header getHeader() {
        return this.header;
    }

    public Body getBody() {
        return this.body;
    }

    public long getReqTime() {
        return this.reqTime;
    }

    public long getResTime() {
        return this.resTime;
    }

    public CmdType getCmdType() {
        return this.cmdType;
    }

    public void setOpaque(long opaque) {
        this.opaque = opaque;
    }

    public void setRequestCode(String requestCode) {
        this.requestCode = requestCode;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public void setReqTime(long reqTime) {
        this.reqTime = reqTime;
    }

    public void setResTime(long resTime) {
        this.resTime = resTime;
    }

    public void setCmdType(CmdType cmdType) {
        this.cmdType = cmdType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpCommand)) {
            return false;
        }
        HttpCommand other = (HttpCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOpaque() != other.getOpaque()) {
            return false;
        }
        if (this.getReqTime() != other.getReqTime()) {
            return false;
        }
        if (this.getResTime() != other.getResTime()) {
            return false;
        }
        String this$requestCode = this.getRequestCode();
        String other$requestCode = other.getRequestCode();
        if (this$requestCode == null ? other$requestCode != null : !this$requestCode.equals(other$requestCode)) {
            return false;
        }
        String this$httpMethod = this.getHttpMethod();
        String other$httpMethod = other.getHttpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) {
            return false;
        }
        String this$httpVersion = this.getHttpVersion();
        String other$httpVersion = other.getHttpVersion();
        if (this$httpVersion == null ? other$httpVersion != null : !this$httpVersion.equals(other$httpVersion)) {
            return false;
        }
        Header this$header = this.getHeader();
        Header other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        Body this$body = this.getBody();
        Body other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        CmdType this$cmdType = this.getCmdType();
        CmdType other$cmdType = other.getCmdType();
        return !(this$cmdType == null ? other$cmdType != null : !((Object)((Object)this$cmdType)).equals((Object)other$cmdType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $opaque = this.getOpaque();
        result = result * 59 + (int)($opaque >>> 32 ^ $opaque);
        long $reqTime = this.getReqTime();
        result = result * 59 + (int)($reqTime >>> 32 ^ $reqTime);
        long $resTime = this.getResTime();
        result = result * 59 + (int)($resTime >>> 32 ^ $resTime);
        String $requestCode = this.getRequestCode();
        result = result * 59 + ($requestCode == null ? 43 : $requestCode.hashCode());
        String $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
        String $httpVersion = this.getHttpVersion();
        result = result * 59 + ($httpVersion == null ? 43 : $httpVersion.hashCode());
        Header $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        Body $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        CmdType $cmdType = this.getCmdType();
        result = result * 59 + ($cmdType == null ? 43 : ((Object)((Object)$cmdType)).hashCode());
        return result;
    }

    public static enum CmdType {
        REQ,
        RES;

    }
}

