/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.file;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.common.file.FileChangeListener;
import org.apache.eventmesh.common.file.WatchFileTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchFileManager.class);
    private static final AtomicBoolean CLOSED = new AtomicBoolean(false);
    private static final Map<String, WatchFileTask> WATCH_FILE_TASK_MAP = new HashMap<String, WatchFileTask>();

    public static void registerFileChangeListener(String directoryPath, FileChangeListener listener) {
        WatchFileTask task = WATCH_FILE_TASK_MAP.get(directoryPath);
        if (task == null) {
            task = new WatchFileTask(directoryPath);
            task.start();
            WATCH_FILE_TASK_MAP.put(directoryPath, task);
        }
        task.addFileChangeListener(listener);
    }

    public static void deregisterFileChangeListener(String directoryPath) {
        WatchFileTask task = WATCH_FILE_TASK_MAP.get(directoryPath);
        if (task != null) {
            task.shutdown();
            WATCH_FILE_TASK_MAP.remove(directoryPath);
        }
    }

    private static void shutdown() {
        if (!CLOSED.compareAndSet(false, true)) {
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[WatchFileManager] start close");
        }
        for (Map.Entry<String, WatchFileTask> entry : WATCH_FILE_TASK_MAP.entrySet()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[WatchFileManager] start to shutdown : {}", (Object)entry.getKey());
            }
            try {
                entry.getValue().shutdown();
            }
            catch (Exception ex) {
                LOGGER.error("[WatchFileManager] shutdown has error : ", (Throwable)ex);
            }
        }
        WATCH_FILE_TASK_MAP.clear();
        LOGGER.warn("[WatchFileManager] already closed");
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOGGER.warn("[WatchFileManager] WatchFileManager closed");
            WatchFileManager.shutdown();
        }));
    }
}

