/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet;

import com.navercorp.pinpoint.rpc.packet.BasicPacket;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class PingPayloadPacket
extends BasicPacket {
    private final int pingId;
    private final byte stateCodeVersion;
    private final byte stateCode;

    public PingPayloadPacket(int pingId, byte stateCode) {
        this(pingId, 0, stateCode);
    }

    public PingPayloadPacket(int pingId, byte stateCodeVersion, byte stateCode) {
        this.pingId = pingId;
        this.stateCodeVersion = stateCodeVersion;
        this.stateCode = stateCode;
    }

    public static PingPayloadPacket readBuffer(short packetType, ChannelBuffer buffer) {
        assert (packetType == 211);
        if (buffer.readableBytes() < 6) {
            buffer.resetReaderIndex();
            return null;
        }
        int pingId = buffer.readInt();
        byte stateVersion = buffer.readByte();
        byte stateCode = buffer.readByte();
        return new PingPayloadPacket(pingId, stateVersion, stateCode);
    }

    @Override
    public short getPacketType() {
        return 211;
    }

    @Override
    public ChannelBuffer toBuffer() {
        ChannelBuffer buffer = ChannelBuffers.buffer((int)8);
        buffer.writeShort(211);
        buffer.writeInt(this.pingId);
        buffer.writeByte((int)this.stateCodeVersion);
        buffer.writeByte((int)this.stateCode);
        return buffer;
    }

    public int getPingId() {
        return this.pingId;
    }

    public byte getStateCodeVersion() {
        return this.stateCodeVersion;
    }

    public byte getStateCode() {
        return this.stateCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PingPayloadPacket{");
        sb.append("pingId=").append(this.pingId);
        sb.append(", stateCodeVersion=").append(this.stateCodeVersion);
        sb.append(", stateCode=").append(this.stateCode);
        sb.append('}');
        return sb.toString();
    }
}

