/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote;

import com.alibaba.nacos.api.remote.Payload;
import com.alibaba.nacos.common.packagescan.DefaultPackageScan;
import com.alibaba.nacos.common.remote.PayloadPackageProvider;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class PayloadRegistry {
    private static final Map<String, Class<?>> REGISTRY_REQUEST = new HashMap();
    static boolean initialized = false;

    public static void init() {
        PayloadRegistry.scan();
    }

    private static synchronized void scan() {
        if (initialized) {
            return;
        }
        ServiceLoader<PayloadPackageProvider> payloadPackages = ServiceLoader.load(PayloadPackageProvider.class);
        HashSet<String> result = new HashSet<String>();
        for (PayloadPackageProvider payloadPackage : payloadPackages) {
            result.addAll(payloadPackage.getScanPackage());
        }
        for (String pkg : result) {
            DefaultPackageScan packageScan = new DefaultPackageScan();
            Set<Class<Payload>> subTypesResponse = packageScan.getSubTypesOf(pkg, Payload.class);
            for (Class<Payload> clazz : subTypesResponse) {
                PayloadRegistry.register(clazz.getSimpleName(), clazz);
            }
        }
        initialized = true;
    }

    static void register(String type, Class<?> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return;
        }
        if (REGISTRY_REQUEST.containsKey(type)) {
            throw new RuntimeException(String.format("Fail to register, type:%s ,clazz:%s ", type, clazz.getName()));
        }
        REGISTRY_REQUEST.put(type, clazz);
    }

    public static Class<?> getClassByType(String type) {
        return REGISTRY_REQUEST.get(type);
    }
}

