/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.BytesUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;

public class AgentUuidUtils {
    private static final char[] CODE_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
    private static final InverseLookup INVERSE_LOOKUP = new InverseLookup(CODE_TABLE);
    private static final int BIT_MASK_6 = 63;
    private static final int BIT_MASK_8 = 255;

    public static String encode(String uuidString) {
        Objects.requireNonNull(uuidString, "uuidString");
        UUID uuid = UUID.fromString(uuidString);
        return AgentUuidUtils.encode(uuid);
    }

    public static String encode(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid");
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        byte[] encoded = AgentUuidUtils.encodeUuidBytes(byteBuffer.array());
        return new String(encoded, StandardCharsets.US_ASCII);
    }

    private static byte[] encodeUuidBytes(byte[] src) {
        if (src.length != 16) {
            throw new IllegalArgumentException("Invalid src byte array: " + BytesUtils.toString(src));
        }
        byte[] dst = new byte[22];
        for (int i = 0; i < 5; ++i) {
            int srcPtr = i * 3;
            int dstPtr = i * 4;
            int currentBits = (src[srcPtr] & 0xFF) << 16;
            currentBits |= (src[srcPtr + 1] & 0xFF) << 8;
            dst[dstPtr] = (byte)CODE_TABLE[(currentBits |= src[srcPtr + 2] & 0xFF) >>> 18 & 0x3F];
            dst[dstPtr + 1] = (byte)CODE_TABLE[currentBits >>> 12 & 0x3F];
            dst[dstPtr + 2] = (byte)CODE_TABLE[currentBits >>> 6 & 0x3F];
            dst[dstPtr + 3] = (byte)CODE_TABLE[currentBits & 0x3F];
        }
        int currentBits = src[15] & 0xFF;
        dst[20] = (byte)CODE_TABLE[currentBits >> 2 & 0x3F];
        dst[21] = (byte)CODE_TABLE[currentBits << 4 & 0x3F];
        return dst;
    }

    public static UUID decode(String src) {
        Objects.requireNonNull(src, "src");
        byte[] decoded = AgentUuidUtils.decodeToUuidBytes(src.getBytes(StandardCharsets.US_ASCII));
        ByteBuffer byteBuffer = ByteBuffer.wrap(decoded);
        long mostSignificantBits = byteBuffer.getLong();
        long leastSignificanBits = byteBuffer.getLong();
        return new UUID(mostSignificantBits, leastSignificanBits);
    }

    private static byte[] decodeToUuidBytes(byte[] src) {
        if (src.length != 22) {
            throw new IllegalArgumentException("Invalid src byte array: " + BytesUtils.toString(src));
        }
        byte[] dst = new byte[16];
        for (int i = 0; i < 5; ++i) {
            int srcPtr = i * 4;
            int dstPtr = i * 3;
            int currentBits = AgentUuidUtils.INVERSE_LOOKUP.lookup(src[srcPtr]) << 18;
            currentBits |= AgentUuidUtils.INVERSE_LOOKUP.lookup(src[srcPtr + 1]) << 12;
            currentBits |= AgentUuidUtils.INVERSE_LOOKUP.lookup(src[srcPtr + 2]) << 6;
            dst[dstPtr] = (byte)((currentBits |= AgentUuidUtils.INVERSE_LOOKUP.lookup(src[srcPtr + 3])) >> 16);
            dst[dstPtr + 1] = (byte)(currentBits >> 8);
            dst[dstPtr + 2] = (byte)currentBits;
        }
        int currentBits = AgentUuidUtils.INVERSE_LOOKUP.lookup(src[20]) << 2 | AgentUuidUtils.INVERSE_LOOKUP.lookup(src[21]) >> 4;
        dst[15] = (byte)currentBits;
        return dst;
    }

    private static class InverseLookup {
        private final int[] inverseCodeTable = new int[256];

        private InverseLookup(char[] codeTable) {
            Arrays.fill(this.inverseCodeTable, -1);
            int i = 0;
            while (i < codeTable.length) {
                int idx = codeTable[i] & 0xFF;
                this.inverseCodeTable[idx] = i++;
            }
        }

        private int lookup(byte c) {
            int idx = this.inverseCodeTable[c & 0xFF];
            if (idx < 0) {
                throw new IllegalArgumentException("Invalid char found: " + c);
            }
            return idx;
        }
    }
}

