---
sidebar_position: 1
---

# Development Roadmap

The development roadmap of Apache EventMesh (Incubating) is an overview of the planned features and milestones involved in the next several releases. The recent features and bug fixes are documented in the [release notes](https://eventmesh.apache.org/events/release-notes/v1.4.0). The order of the features listed below doesn't correspond to their priorities.

## List of Features and Milestones

| Status                                    | Description                     | Reference |
|-------------------------------------------|---------------------------------|  --- |
| **Implemented in 1.0.0**                  | Support HTTP                    | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.0.0**                  | Support TCP                     | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.0.0**                  | Support Pub/Sub Event           | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.1.1**                  | Provide Java SDK                | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.1.1**                  | Support HTTPS                   | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.2.0**                  | Support RocketMQ as EventStore  | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.2.0**                  | Support Heartbeat               | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.3.0**                  | Integrate with OpenSchema       | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.3.0**                  | Integrate with OpenTelemetry    | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.3.0**                  | Support CloudEvents             | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.4.0**                  | Support gRPC                    | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.5.0**                  | Provide Golang SDK              | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.5.0**                  | Support Nacos Registry          | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.5.0**                  | Support Mesh Bridge             | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.5.0**                  | Support  Federal Government     | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.5.0**                  | Support Mesh Bridge             | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.6.0**                  | Integrate with Consul           | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.6.0**                  | Support Webhook                 | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.6.0**                  | Support etcd                    | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.7.0(to be release)**                           | Support Knative Eventing Infrastructure | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/790), [GSoC '22](https://issues.apache.org/jira/browse/COMDEV-463) |
| **Implemented in 1.7.0(to be release)**                           | Support Pravega as EventStore   | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/270)  |
| **Implemented in 1.7.0(to be release)**                           | Support Kafka as EventStore     | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/676) |
| **Implemented in 1.7.0(to be release)**                           | Support Pulsar as EventStore    | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/676) |
| **Implemented in 1.7.0(to be release)**                           | Support CNCF Serverless Workflow| [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.7.0(to be release)**                           | Support Redis                   | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.7.0(to be release)**                           | Provide Rust SDK                        | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/815) |
| **Implemented in 1.7.0(to be release)**                           | Support Zookeeper               | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **Implemented in 1.7.0(to be release)**                           | Support RabbitMQ as EventStore               | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/1553) |
| **In Progress**                           | Provide Dashboard                       | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/700), [GSoC '22](https://issues.apache.org/jira/browse/COMDEV-465)
| **In Progress**                           | Support Filter Chain                    | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/664) |
| **In Progress**                           | Metadata consistency persistent | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/817)  |
| Planned                                   | Support Dledger                 | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| Planned                                   | Provide NodeJS SDK              | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| Planned                                   | Provide PHP    SDK              | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/1193) |
| Planned                                   | Transaction Event               | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/697) |
| Planned                                   | Event Query Language (EQL)      | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/778) |
| Planned                                   | WebAssembly Runtime             | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/576) |

