/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push;

import io.cloudevents.CloudEvent;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.runtime.core.plugin.MQConsumerWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.retry.RetryContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.ServerGlobal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownStreamMsgContext
extends RetryContext {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public Session session;
    public AbstractContext consumeConcurrentlyContext;
    public MQConsumerWrapper consumer;
    public SubscriptionItem subscriptionItem;
    public long lastPushTime;
    private final long createTime;
    private final long expireTime;
    public boolean msgFromOtherEventMesh;

    public DownStreamMsgContext(CloudEvent event, Session session, MQConsumerWrapper consumer, AbstractContext consumeConcurrentlyContext, boolean msgFromOtherEventMesh, SubscriptionItem subscriptionItem) {
        this.seq = String.valueOf(ServerGlobal.getInstance().getMsgCounter().incrementAndGet());
        this.event = event;
        this.session = session;
        this.consumer = consumer;
        this.consumeConcurrentlyContext = consumeConcurrentlyContext;
        this.lastPushTime = System.currentTimeMillis();
        this.createTime = System.currentTimeMillis();
        this.subscriptionItem = subscriptionItem;
        String ttlStr = (String)event.getExtension("TTL");
        long ttl = StringUtils.isNumeric((CharSequence)ttlStr) ? Long.parseLong(ttlStr) : 3000L;
        this.expireTime = System.currentTimeMillis() + ttl;
        this.msgFromOtherEventMesh = msgFromOtherEventMesh;
    }

    public boolean isExpire() {
        return System.currentTimeMillis() >= this.expireTime;
    }

    public void ackMsg() {
        if (this.consumer != null && this.consumeConcurrentlyContext != null && this.event != null) {
            ArrayList<CloudEvent> events = new ArrayList<CloudEvent>();
            events.add(this.event);
            this.consumer.updateOffset(events, this.consumeConcurrentlyContext);
            this.logger.info("ackMsg seq:{}, topic:{}, bizSeq:{}", new Object[]{this.seq, ((CloudEvent)events.get(0)).getSubject(), ((CloudEvent)events.get(0)).getExtension("keys")});
        } else {
            this.logger.warn("ackMsg seq:{} failed,consumer is null:{}, context is null:{} , msgs is null:{}", new Object[]{this.seq, this.consumer == null, this.consumeConcurrentlyContext == null, this.event == null});
        }
    }

    public String toString() {
        return "DownStreamMsgContext{,seq=" + this.seq + ",client=" + (this.session == null ? null : this.session.getClient()) + ",retryTimes=" + this.retryTimes + ",consumer=" + this.consumer + ",topic=" + this.event.getSubject() + ",subscriptionItem=" + this.subscriptionItem + ",createTime=" + DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + ",executeTime=" + DateFormatUtils.format((long)this.executeTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + ",lastPushTime=" + DateFormatUtils.format((long)this.lastPushTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + "}";
    }

    @Override
    public void retry() {
        try {
            this.logger.info("retry downStream msg start,seq:{},retryTimes:{},bizSeq:{}", new Object[]{this.seq, this.retryTimes, EventMeshUtil.getMessageBizSeq(this.event)});
            if (this.isRetryMsgTimeout(this)) {
                return;
            }
            ++this.retryTimes;
            this.lastPushTime = System.currentTimeMillis();
            String topic = this.event.getSubject();
            Session rechoosen = !SubscriptionMode.BROADCASTING.equals((Object)this.subscriptionItem.getMode()) ? Objects.requireNonNull((ClientGroupWrapper)this.session.getClientGroupWrapper().get()).getDownstreamDispatchStrategy().select(Objects.requireNonNull((ClientGroupWrapper)this.session.getClientGroupWrapper().get()).getSysId(), topic, Objects.requireNonNull((ClientGroupWrapper)this.session.getClientGroupWrapper().get()).getGroupConsumerSessions()) : this.session;
            if (rechoosen == null) {
                this.logger.warn("retry, found no session to downstream msg,seq:{}, retryTimes:{}, bizSeq:{}", new Object[]{this.seq, this.retryTimes, EventMeshUtil.getMessageBizSeq(this.event)});
            } else {
                this.session = rechoosen;
                rechoosen.downstreamMsg(this);
                this.logger.info("retry downStream msg end,seq:{},retryTimes:{},bizSeq:{}", new Object[]{this.seq, this.retryTimes, EventMeshUtil.getMessageBizSeq(this.event)});
            }
        }
        catch (Exception e) {
            this.logger.error("retry-dispatcher error!", (Throwable)e);
        }
    }

    private boolean isRetryMsgTimeout(DownStreamMsgContext downStreamMsgContext) {
        String arriveTimeStr;
        long accessCost;
        boolean flag = false;
        String ttlStr = (String)downStreamMsgContext.event.getExtension("ttl");
        long ttl = StringUtils.isNumeric((CharSequence)ttlStr) ? Long.parseLong(ttlStr) : 3000L;
        String storeTimeStr = (String)downStreamMsgContext.event.getExtension("store99time");
        long storeTimestamp = StringUtils.isNumeric((CharSequence)storeTimeStr) ? Long.parseLong(storeTimeStr) : 0L;
        String leaveTimeStr = (String)downStreamMsgContext.event.getExtension("leave99time");
        long brokerCost = StringUtils.isNumeric((CharSequence)leaveTimeStr) ? Long.parseLong(leaveTimeStr) - storeTimestamp : 0L;
        double elapseTime = brokerCost + (accessCost = StringUtils.isNumeric((CharSequence)(arriveTimeStr = (String)downStreamMsgContext.event.getExtension("arrive99time"))) ? System.currentTimeMillis() - Long.parseLong(arriveTimeStr) : 0L);
        if (elapseTime >= (double)ttl) {
            this.logger.warn("discard the retry because timeout, seq:{}, retryTimes:{}, bizSeq:{}", new Object[]{downStreamMsgContext.seq, downStreamMsgContext.retryTimes, EventMeshUtil.getMessageBizSeq(downStreamMsgContext.event)});
            flag = true;
            this.eventMeshAckMsg(downStreamMsgContext);
        }
        return flag;
    }

    private void eventMeshAckMsg(DownStreamMsgContext downStreamMsgContext) {
        ArrayList<CloudEvent> msgExts = new ArrayList<CloudEvent>();
        msgExts.add(downStreamMsgContext.event);
        this.logger.warn("eventMeshAckMsg topic:{}, seq:{}, bizSeq:{}", new Object[]{downStreamMsgContext.event.getSubject(), downStreamMsgContext.seq, downStreamMsgContext.event.getExtension("keys")});
        downStreamMsgContext.consumer.updateOffset(msgExts, downStreamMsgContext.consumeConcurrentlyContext);
    }
}

