/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor.inf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.registry.dto.EventMeshDataInfo;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupMetadata;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicMetadata;
import org.apache.eventmesh.runtime.registry.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractEventProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AbstractEventProcessor");
    protected EventMeshHTTPServer eventMeshHTTPServer;

    public AbstractEventProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    protected void updateMetadata() {
        if (!this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerRegistryEnable) {
            return;
        }
        try {
            HashMap<String, String> metadata = new HashMap<String, String>(16);
            for (Map.Entry<String, ConsumerGroupConf> consumerGroupMap : this.eventMeshHTTPServer.localConsumerGroupMapping.entrySet()) {
                String consumerGroupKey = consumerGroupMap.getKey();
                ConsumerGroupConf consumerGroupConf = consumerGroupMap.getValue();
                ConsumerGroupMetadata consumerGroupMetadata = new ConsumerGroupMetadata();
                consumerGroupMetadata.setConsumerGroup(consumerGroupKey);
                HashMap<String, ConsumerGroupTopicMetadata> consumerGroupTopicMetadataMap = new HashMap<String, ConsumerGroupTopicMetadata>(16);
                for (Map.Entry<String, ConsumerGroupTopicConf> consumerGroupTopicConfEntry : consumerGroupConf.getConsumerGroupTopicConf().entrySet()) {
                    String topic = consumerGroupTopicConfEntry.getKey();
                    ConsumerGroupTopicConf consumerGroupTopicConf = consumerGroupTopicConfEntry.getValue();
                    ConsumerGroupTopicMetadata consumerGroupTopicMetadata = new ConsumerGroupTopicMetadata();
                    consumerGroupTopicMetadata.setConsumerGroup(consumerGroupTopicConf.getConsumerGroup());
                    consumerGroupTopicMetadata.setTopic(consumerGroupTopicConf.getTopic());
                    consumerGroupTopicMetadata.setUrls(consumerGroupTopicConf.getUrls());
                    consumerGroupTopicMetadataMap.put(topic, consumerGroupTopicMetadata);
                }
                consumerGroupMetadata.setConsumerGroupTopicMetadataMap(consumerGroupTopicMetadataMap);
                metadata.put(consumerGroupKey, JsonUtils.serialize((Object)consumerGroupMetadata));
            }
            Registry registry = this.eventMeshHTTPServer.getRegistry();
            registry.registerMetadata(metadata);
        }
        catch (Exception e) {
            LOGGER.error("[LocalSubscribeEventProcessor] update eventmesh metadata error", (Throwable)e);
        }
    }

    protected String getTargetMesh(String consumerGroup, List<SubscriptionItem> subscriptionList) throws Exception {
        EventMeshHTTPConfiguration httpConfiguration = this.eventMeshHTTPServer.getEventMeshHttpConfiguration();
        if (!httpConfiguration.eventMeshServerRegistryEnable) {
            return "";
        }
        Object targetMesh = "";
        Registry registry = this.eventMeshHTTPServer.getRegistry();
        List<EventMeshDataInfo> allEventMeshInfo = registry.findAllEventMeshInfo();
        String httpServiceName = "HTTP-GROUP@@" + httpConfiguration.eventMeshName + "-HTTP";
        block0: for (EventMeshDataInfo eventMeshDataInfo : allEventMeshInfo) {
            Map metadata;
            String topicMetadataJson;
            if (!eventMeshDataInfo.getEventMeshName().equals(httpServiceName) || httpConfiguration.eventMeshCluster.equals(eventMeshDataInfo.getEventMeshClusterName()) || StringUtils.isBlank((CharSequence)(topicMetadataJson = (String)(metadata = eventMeshDataInfo.getMetadata()).get(consumerGroup)))) continue;
            ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)JsonUtils.deserialize((String)topicMetadataJson, ConsumerGroupMetadata.class);
            Map<String, ConsumerGroupTopicMetadata> consumerGroupTopicMetadataMap = consumerGroupMetadata.getConsumerGroupTopicMetadataMap();
            for (SubscriptionItem subscriptionItem : subscriptionList) {
                if (!consumerGroupTopicMetadataMap.containsKey(subscriptionItem.getTopic())) continue;
                targetMesh = "http://" + eventMeshDataInfo.getEndpoint() + "/eventmesh/subscribe/local";
                break block0;
            }
        }
        return targetMesh;
    }
}

