/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.eventmesh.runtime.common.EventMeshTrace;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HttpProcessor;
import org.apache.eventmesh.runtime.util.HttpResponseUtils;
import org.apache.eventmesh.webhook.receive.WebHookController;

@EventMeshTrace(isEnable=true)
public class WebHookProcessor
implements HttpProcessor {
    private WebHookController webHookController;

    @Override
    public String[] paths() {
        return new String[]{"/webhook"};
    }

    @Override
    public HttpResponse handler(HttpRequest httpRequest) {
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            for (Map.Entry entry : httpRequest.headers().entries()) {
                header.put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue());
            }
            ByteBuf buf = ((FullHttpRequest)httpRequest).content();
            this.webHookController.execute(httpRequest.uri(), header, ByteBufUtil.getBytes((ByteBuf)buf));
            return HttpResponseUtils.createSuccess();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setWebHookController(WebHookController webHookController) {
        this.webHookController = webHookController;
    }
}

