/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.client.UnSubscribeRequestBody;
import org.apache.eventmesh.common.protocol.http.body.client.UnSubscribeResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.client.UnSubscribeRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.client.UnSubscribeResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnSubscribeProcessor
implements HttpRequestProcessor {
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");
    private EventMeshHTTPServer eventMeshHTTPServer;

    public UnSubscribeProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(final ChannelHandlerContext ctx, final AsyncContext<HttpCommand> asyncContext) throws Exception {
        this.httpLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtils.getLocalAddress()});
        UnSubscribeRequestHeader unSubscribeRequestHeader = (UnSubscribeRequestHeader)asyncContext.getRequest().getHeader();
        UnSubscribeRequestBody unSubscribeRequestBody = (UnSubscribeRequestBody)asyncContext.getRequest().getBody();
        UnSubscribeResponseHeader unSubscribeResponseHeader = UnSubscribeResponseHeader.buildHeader((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode()), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster, (String)IPUtils.getLocalAddress(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        if (StringUtils.isBlank((CharSequence)unSubscribeRequestHeader.getIdc()) || StringUtils.isBlank((CharSequence)unSubscribeRequestHeader.getPid()) || !StringUtils.isNumeric((CharSequence)unSubscribeRequestHeader.getPid()) || StringUtils.isBlank((CharSequence)unSubscribeRequestHeader.getSys())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)unSubscribeResponseHeader, (Body)UnSubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        if (StringUtils.isBlank((CharSequence)unSubscribeRequestBody.getUrl()) || CollectionUtils.isEmpty((Collection)unSubscribeRequestBody.getTopics()) || StringUtils.isBlank((CharSequence)unSubscribeRequestBody.getConsumerGroup())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)unSubscribeResponseHeader, (Body)UnSubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        String env = unSubscribeRequestHeader.getEnv();
        String idc = unSubscribeRequestHeader.getIdc();
        String sys = unSubscribeRequestHeader.getSys();
        String ip = unSubscribeRequestHeader.getIp();
        String pid = unSubscribeRequestHeader.getPid();
        String consumerGroup = unSubscribeRequestBody.getConsumerGroup();
        String unSubscribeUrl = unSubscribeRequestBody.getUrl();
        List unSubTopicList = unSubscribeRequestBody.getTopics();
        CompleteHandler<HttpCommand> handler = new CompleteHandler<HttpCommand>(){

            @Override
            public void onResponse(HttpCommand httpCommand) {
                try {
                    if (UnSubscribeProcessor.this.httpLogger.isDebugEnabled()) {
                        UnSubscribeProcessor.this.httpLogger.debug("{}", (Object)httpCommand);
                    }
                    UnSubscribeProcessor.this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                    UnSubscribeProcessor.this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - ((HttpCommand)asyncContext.getRequest()).getReqTime());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        ConcurrentHashMap<String, List<Client>> concurrentHashMap = this.eventMeshHTTPServer.localClientInfoMapping;
        synchronized (concurrentHashMap) {
            HttpCommand err;
            boolean isChange = true;
            this.registerClient(unSubscribeRequestHeader, consumerGroup, unSubTopicList, unSubscribeUrl);
            for (String unSubTopic : unSubTopicList) {
                List<Client> groupTopicClients = this.eventMeshHTTPServer.localClientInfoMapping.get(consumerGroup + "@" + unSubTopic);
                Iterator<Client> clientIterator = groupTopicClients.iterator();
                while (clientIterator.hasNext()) {
                    Client client = clientIterator.next();
                    if (!StringUtils.equals((CharSequence)client.pid, (CharSequence)pid) || !StringUtils.equals((CharSequence)client.url, (CharSequence)unSubscribeUrl)) continue;
                    this.httpLogger.warn("client {} start unsubscribe", (Object)JsonUtils.serialize((Object)client));
                    clientIterator.remove();
                }
                if (groupTopicClients.size() > 0) {
                    HashMap<String, List<String>> idcUrls = new HashMap<String, List<String>>();
                    HashSet<String> clientUrls = new HashSet<String>();
                    for (Client client : groupTopicClients) {
                        if (StringUtils.equals((CharSequence)unSubscribeUrl, (CharSequence)client.url)) continue;
                        clientUrls.add(client.url);
                        if (idcUrls.containsKey(client.idc)) {
                            ((List)idcUrls.get(client.idc)).add(StringUtils.deleteWhitespace((String)client.url));
                            continue;
                        }
                        ArrayList<String> urls = new ArrayList<String>();
                        urls.add(client.url);
                        idcUrls.put(client.idc, urls);
                    }
                    ConcurrentHashMap<String, ConsumerGroupConf> concurrentHashMap2 = this.eventMeshHTTPServer.localConsumerGroupMapping;
                    synchronized (concurrentHashMap2) {
                        ConsumerGroupConf consumerGroupConf = this.eventMeshHTTPServer.localConsumerGroupMapping.get(consumerGroup);
                        Map<String, ConsumerGroupTopicConf> map = consumerGroupConf.getConsumerGroupTopicConf();
                        for (Map.Entry<String, ConsumerGroupTopicConf> topicConf : map.entrySet()) {
                            if (!StringUtils.equals((CharSequence)unSubTopic, (CharSequence)topicConf.getKey())) continue;
                            ConsumerGroupTopicConf latestTopicConf = new ConsumerGroupTopicConf();
                            latestTopicConf.setConsumerGroup(consumerGroup);
                            latestTopicConf.setTopic(unSubTopic);
                            latestTopicConf.setSubscriptionItem(topicConf.getValue().getSubscriptionItem());
                            latestTopicConf.setUrls(clientUrls);
                            latestTopicConf.setIdcUrls(idcUrls);
                            map.put(unSubTopic, latestTopicConf);
                        }
                        this.eventMeshHTTPServer.localConsumerGroupMapping.put(consumerGroup, consumerGroupConf);
                        continue;
                    }
                }
                isChange = false;
                break;
            }
            long startTime = System.currentTimeMillis();
            if (isChange) {
                try {
                    this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, this.eventMeshHTTPServer.localConsumerGroupMapping.get(consumerGroup));
                    HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse(EventMeshRetCode.SUCCESS);
                    asyncContext.onComplete(responseEventMeshCommand, handler);
                }
                catch (Exception e) {
                    err = asyncContext.getRequest().createHttpCommandResponse((Header)unSubscribeResponseHeader, (Body)UnSubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
                    asyncContext.onComplete(err);
                    long endTime = System.currentTimeMillis();
                    this.httpLogger.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, JsonUtils.serialize((Object)unSubscribeRequestBody.getTopics()), unSubscribeRequestBody.getUrl(), e});
                    this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgFailed();
                    this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgCost(endTime - startTime);
                }
            } else {
                try {
                    this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, null);
                    HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse(EventMeshRetCode.SUCCESS);
                    asyncContext.onComplete(responseEventMeshCommand, handler);
                    this.eventMeshHTTPServer.localClientInfoMapping.keySet().removeIf(s -> StringUtils.contains((CharSequence)s, (CharSequence)consumerGroup));
                    this.eventMeshHTTPServer.localConsumerGroupMapping.keySet().removeIf(s -> StringUtils.equals((CharSequence)consumerGroup, (CharSequence)s));
                }
                catch (Exception e) {
                    err = asyncContext.getRequest().createHttpCommandResponse((Header)unSubscribeResponseHeader, (Body)UnSubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
                    asyncContext.onComplete(err);
                    long endTime = System.currentTimeMillis();
                    this.httpLogger.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, JsonUtils.serialize((Object)unSubscribeRequestBody.getTopics()), unSubscribeRequestBody.getUrl(), e});
                    this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgFailed();
                    this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgCost(endTime - startTime);
                }
            }
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }

    private void registerClient(UnSubscribeRequestHeader unSubscribeRequestHeader, String consumerGroup, List<String> topicList, String url) {
        for (String topic : topicList) {
            Client client = new Client();
            client.env = unSubscribeRequestHeader.getEnv();
            client.idc = unSubscribeRequestHeader.getIdc();
            client.sys = unSubscribeRequestHeader.getSys();
            client.ip = unSubscribeRequestHeader.getIp();
            client.pid = unSubscribeRequestHeader.getPid();
            client.consumerGroup = consumerGroup;
            client.topic = topic;
            client.url = url;
            client.lastUpTime = new Date();
            String groupTopicKey = client.consumerGroup + "@" + client.topic;
            if (this.eventMeshHTTPServer.localClientInfoMapping.containsKey(groupTopicKey)) {
                List<Client> localClients = this.eventMeshHTTPServer.localClientInfoMapping.get(groupTopicKey);
                boolean isContains = false;
                for (Client localClient : localClients) {
                    if (!StringUtils.equals((CharSequence)localClient.url, (CharSequence)client.url)) continue;
                    isContains = true;
                    localClient.lastUpTime = client.lastUpTime;
                    break;
                }
                if (isContains) continue;
                localClients.add(client);
                continue;
            }
            ArrayList<Client> clients = new ArrayList<Client>();
            clients.add(client);
            this.eventMeshHTTPServer.localClientInfoMapping.put(groupTopicKey, clients);
        }
    }
}

