/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.api.trace.Span;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.trace.TraceUtils;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendAsyncMessageProcessor
implements HttpRequestProcessor {
    public Logger messageLogger = LoggerFactory.getLogger((String)"message");
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");
    public Logger cmdLogger = LoggerFactory.getLogger((String)"cmd");
    public Logger aclLogger = LoggerFactory.getLogger((String)"acl");
    private EventMeshHTTPServer eventMeshHTTPServer;

    public SendAsyncMessageProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(final ChannelHandlerContext ctx, final AsyncContext<HttpCommand> asyncContext) throws Exception {
        String content;
        this.cmdLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtils.getLocalAddress()});
        SendMessageRequestHeader sendMessageRequestHeader = (SendMessageRequestHeader)asyncContext.getRequest().getHeader();
        final SendMessageResponseHeader sendMessageResponseHeader = SendMessageResponseHeader.buildHeader((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode()), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster, (String)IPUtils.getLocalAddress(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        String protocolType = sendMessageRequestHeader.getProtocolType();
        final String protocolVersin = sendMessageRequestHeader.getProtocolVersion();
        ProtocolAdaptor httpCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        CloudEvent event = httpCommandProtocolAdaptor.toCloudEvent((ProtocolTransportObject)asyncContext.getRequest());
        final Span span = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), "upstream-eventmesh-server-span", true);
        if (event == null || StringUtils.isBlank((CharSequence)event.getId()) || event.getSource() == null || event.getSpecVersion() == null || StringUtils.isBlank((CharSequence)event.getType()) || StringUtils.isBlank((CharSequence)event.getSubject())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            Span excepSpan = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), "upstream-eventmesh-server-span", false);
            TraceUtils.finishSpanWithException(excepSpan, EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg(), null);
            return;
        }
        String idc = Objects.requireNonNull(event.getExtension("idc")).toString();
        String pid = Objects.requireNonNull(event.getExtension("pid")).toString();
        String sys = Objects.requireNonNull(event.getExtension("sys")).toString();
        if (StringUtils.isBlank((CharSequence)idc) || StringUtils.isBlank((CharSequence)pid) || !StringUtils.isNumeric((CharSequence)pid) || StringUtils.isBlank((CharSequence)sys)) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            Span excepSpan = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), "upstream-eventmesh-server-span", false);
            TraceUtils.finishSpanWithException(excepSpan, EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg(), null);
            return;
        }
        final String bizNo = Objects.requireNonNull(event.getExtension("bizseqno")).toString();
        final String uniqueId = Objects.requireNonNull(event.getExtension("uniqueid")).toString();
        String producerGroup = Objects.requireNonNull(event.getExtension("producergroup")).toString();
        final String topic = event.getSubject();
        if (StringUtils.isBlank((CharSequence)bizNo) || StringUtils.isBlank((CharSequence)uniqueId) || StringUtils.isBlank((CharSequence)producerGroup) || StringUtils.isBlank((CharSequence)topic) || event.getData() == null) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            Span excepSpan = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), "upstream-eventmesh-server-span", false);
            TraceUtils.finishSpanWithException(excepSpan, EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg(), null);
            return;
        }
        if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerSecurityEnable) {
            String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            String user = Objects.requireNonNull(event.getExtension("username")).toString();
            String pass = Objects.requireNonNull(event.getExtension("passwd")).toString();
            String subsystem = Objects.requireNonNull(event.getExtension("sys")).toString();
            int requestCode = Integer.parseInt(asyncContext.getRequest().getRequestCode());
            try {
                Acl.doAclCheckInHttpSend(remoteAddr, user, pass, subsystem, topic, requestCode);
            }
            catch (Exception e) {
                HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_ACL_ERR.getRetCode(), (String)e.getMessage()));
                asyncContext.onComplete(responseEventMeshCommand);
                this.aclLogger.warn("CLIENT HAS NO PERMISSION,SendAsyncMessageProcessor send failed", (Throwable)e);
                Span excepSpan = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), "upstream-eventmesh-server-span", false);
                TraceUtils.finishSpanWithException(excepSpan, EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), EventMeshRetCode.EVENTMESH_ACL_ERR.getErrMsg(), null);
                return;
            }
        }
        if (!this.eventMeshHTTPServer.getMsgRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR.getErrMsg()));
            this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordHTTPDiscard();
            asyncContext.onComplete(responseEventMeshCommand);
            Span excepSpan = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), "upstream-eventmesh-server-span", false);
            TraceUtils.finishSpanWithException(excepSpan, EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR.getErrMsg(), null);
            return;
        }
        EventMeshProducer eventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        if (!eventMeshProducer.getStarted().get()) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            Span excepSpan = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), "upstream-eventmesh-server-span", false);
            TraceUtils.finishSpanWithException(excepSpan, EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR.getErrMsg(), null);
            return;
        }
        String ttl = String.valueOf(EventMeshConstants.DEFAULT_MSG_TTL_MILLS);
        if (StringUtils.isBlank((CharSequence)Objects.requireNonNull(event.getExtension("ttl")).toString()) && !StringUtils.isNumeric((CharSequence)Objects.requireNonNull(event.getExtension("ttl")).toString())) {
            event = CloudEventBuilder.from((CloudEvent)event).withExtension("ttl", ttl).build();
        }
        String string = content = event.getData() == null ? "" : new String(event.getData().toBytes(), StandardCharsets.UTF_8);
        if (content.length() > this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize) {
            this.httpLogger.error("Event size exceeds the limit: {}", (Object)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize);
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_SIZE_ERR.getRetCode(), (String)("Event size exceeds the limit: " + this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize)));
            asyncContext.onComplete(responseEventMeshCommand);
            Span excepSpan = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), "upstream-eventmesh-server-span", false);
            TraceUtils.finishSpanWithException(excepSpan, EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_SIZE_ERR.getErrMsg(), null);
            return;
        }
        try {
            event = CloudEventBuilder.from((CloudEvent)event).withExtension("msgtype", "persistent").withExtension("reqc2eventmeshtimestamp", (Number)asyncContext.getRequest().reqTime).withExtension("reqsendeventmeship", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerIp).build();
            if (this.messageLogger.isDebugEnabled()) {
                this.messageLogger.debug("msg2MQMsg suc, bizSeqNo={}, topic={}", (Object)bizNo, (Object)topic);
            }
        }
        catch (Exception e) {
            this.messageLogger.error("msg2MQMsg err, bizSeqNo={}, topic={}", new Object[]{bizNo, topic, e});
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
            asyncContext.onComplete(responseEventMeshCommand);
            Span excepSpan = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), "upstream-eventmesh-server-span", false);
            TraceUtils.finishSpanWithException(excepSpan, EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getErrMsg(), null);
            return;
        }
        final SendMessageContext sendMessageContext = new SendMessageContext(bizNo, event, eventMeshProducer, this.eventMeshHTTPServer);
        this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsg();
        final long startTime = System.currentTimeMillis();
        final CompleteHandler<HttpCommand> handler = new CompleteHandler<HttpCommand>(){

            @Override
            public void onResponse(HttpCommand httpCommand) {
                try {
                    if (SendAsyncMessageProcessor.this.httpLogger.isDebugEnabled()) {
                        SendAsyncMessageProcessor.this.httpLogger.debug("{}", (Object)httpCommand);
                    }
                    SendAsyncMessageProcessor.this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                    SendAsyncMessageProcessor.this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - ((HttpCommand)asyncContext.getRequest()).getReqTime());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        try {
            event = CloudEventBuilder.from((CloudEvent)sendMessageContext.getEvent()).withExtension("reqeventmesh2mqtimestamp", String.valueOf(System.currentTimeMillis())).build();
            sendMessageContext.setEvent(event);
            Span clientSpan = TraceUtils.prepareClientSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), "upstream-eventmesh-client-span", false);
            try {
                eventMeshProducer.send(sendMessageContext, new SendCallback(){

                    public void onSuccess(SendResult sendResult) {
                        HttpCommand succ = ((HttpCommand)asyncContext.getRequest()).createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.SUCCESS.getRetCode(), (String)(EventMeshRetCode.SUCCESS.getErrMsg() + sendResult.toString())));
                        asyncContext.onComplete(succ, handler);
                        long endTime = System.currentTimeMillis();
                        SendAsyncMessageProcessor.this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgCost(endTime - startTime);
                        SendAsyncMessageProcessor.this.messageLogger.info("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, bizNo, uniqueId});
                        TraceUtils.finishSpan(span, sendMessageContext.getEvent());
                    }

                    public void onException(OnExceptionContext context) {
                        HttpCommand err = ((HttpCommand)asyncContext.getRequest()).createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace((Throwable)context.getException(), 2))));
                        asyncContext.onComplete(err, handler);
                        SendAsyncMessageProcessor.this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
                        long endTime = System.currentTimeMillis();
                        SendAsyncMessageProcessor.this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgFailed();
                        SendAsyncMessageProcessor.this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgCost(endTime - startTime);
                        SendAsyncMessageProcessor.this.messageLogger.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, bizNo, uniqueId, context.getException()});
                        TraceUtils.finishSpanWithException(span, EventMeshUtil.getCloudEventExtensionMap(protocolVersin, sendMessageContext.getEvent()), EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getErrMsg(), (Throwable)context.getException());
                    }
                });
            }
            finally {
                TraceUtils.finishSpan(clientSpan, event);
            }
        }
        catch (Exception ex) {
            HttpCommand err = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(ex, 2))));
            asyncContext.onComplete(err);
            Span excepSpan = TraceUtils.prepareServerSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), "upstream-eventmesh-server-span", false);
            TraceUtils.finishSpanWithException(excepSpan, EventMeshUtil.getCloudEventExtensionMap(protocolVersin, event), EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getErrMsg(), null);
            this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
            long endTime = System.currentTimeMillis();
            this.messageLogger.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, bizNo, uniqueId, ex});
            this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgFailed();
            this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgCost(endTime - startTime);
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

