/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestURI;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.common.EventMeshTrace;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.AsyncHttpProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.AbstractEventProcessor;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshTrace(isEnable=false)
public class RemoteUnSubscribeEventProcessor
extends AbstractEventProcessor
implements AsyncHttpProcessor {
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");
    public Logger aclLogger = LoggerFactory.getLogger((String)"acl");

    public RemoteUnSubscribeEventProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        super(eventMeshHTTPServer);
    }

    @Override
    public void handler(HandlerService.HandlerSpecific handlerSpecific, HttpRequest httpRequest) throws Exception {
        AsyncContext<HttpEventWrapper> asyncContext = handlerSpecific.getAsyncContext();
        ChannelHandlerContext ctx = handlerSpecific.getCtx();
        HttpEventWrapper requestWrapper = asyncContext.getRequest();
        this.httpLogger.info("uri={}|{}|client2eventMesh|from={}|to={}", new Object[]{requestWrapper.getRequestURI(), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtils.getLocalAddress()});
        Map userRequestHeaderMap = requestWrapper.getHeaderMap();
        String requestIp = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        userRequestHeaderMap.put("ip", requestIp);
        requestWrapper.buildSysHeaderForClient();
        HashMap<String, Object> responseHeaderMap = new HashMap<String, Object>();
        responseHeaderMap.put("uri", requestWrapper.getRequestURI());
        responseHeaderMap.put("eventmeshcluster", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster);
        responseHeaderMap.put("eventmeship", IPUtils.getLocalAddress());
        responseHeaderMap.put("eventmeshenv", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv);
        responseHeaderMap.put("eventmeshidc", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        Map sysHeaderMap = requestWrapper.getSysHeaderMap();
        HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)sysHeaderMap.get("idc").toString()) || StringUtils.isBlank((CharSequence)sysHeaderMap.get("pid").toString()) || !StringUtils.isNumeric((CharSequence)sysHeaderMap.get("pid").toString()) || StringUtils.isBlank((CharSequence)sysHeaderMap.get("sys").toString())) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        byte[] requestBody = requestWrapper.getBody();
        Map requestBodyMap = (Map)JsonUtils.deserialize((String)new String(requestBody, Constants.DEFAULT_CHARSET), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        if (requestBodyMap.get("url") == null || requestBodyMap.get("topic") == null || requestBodyMap.get("consumerGroup") == null) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        String unSubscribeUrl = requestBodyMap.get("url").toString();
        String consumerGroup = requestBodyMap.get("consumerGroup").toString();
        String topic = requestBodyMap.get("topic").toString();
        long startTime = System.currentTimeMillis();
        try {
            List<SubscriptionItem> subscriptionList;
            String meshAddress;
            String env = this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv;
            String idc = this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC;
            String cluster = this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster;
            String sysId = this.eventMeshHTTPServer.getEventMeshHttpConfiguration().sysID;
            String meshGroup = env + "-" + idc + "-" + cluster + "-" + sysId;
            HashMap<String, String> remoteHeaderMap = new HashMap<String, String>();
            remoteHeaderMap.put("env", env);
            remoteHeaderMap.put("idc", idc);
            remoteHeaderMap.put("ip", IPUtils.getLocalAddress());
            remoteHeaderMap.put("pid", String.valueOf(ThreadUtils.getPID()));
            remoteHeaderMap.put("sys", sysId);
            remoteHeaderMap.put("username", "eventmesh");
            remoteHeaderMap.put("passwd", "pass");
            remoteHeaderMap.put("producergroup", meshGroup);
            remoteHeaderMap.put("consumergroup", meshGroup);
            String unsubscribeUrl = "http://" + IPUtils.getLocalAddress() + ":" + this.eventMeshHTTPServer.getEventMeshHttpConfiguration().httpServerPort + RequestURI.PUBLISH_BRIDGE.getRequestURI();
            HashMap<String, Object> remoteBodyMap = new HashMap<String, Object>();
            remoteBodyMap.put("url", unsubscribeUrl);
            remoteBodyMap.put("consumerGroup", meshGroup);
            remoteBodyMap.put("topic", requestBodyMap.get("topic"));
            List unSubTopicList = (List)JsonUtils.deserialize((String)JsonUtils.serialize(requestBodyMap.get("topic")), (TypeReference)new TypeReference<List<String>>(){});
            String targetMesh = "";
            if (!Objects.isNull(requestBodyMap.get("remoteMesh"))) {
                targetMesh = requestBodyMap.get("remoteMesh").toString();
            }
            if (StringUtils.isNotBlank((CharSequence)(meshAddress = this.getTargetMesh(consumerGroup, subscriptionList = unSubTopicList.stream().map(s -> {
                SubscriptionItem subscriptionItem = new SubscriptionItem();
                subscriptionItem.setTopic(s);
                return subscriptionItem;
            }).collect(Collectors.toList()))))) {
                targetMesh = meshAddress;
            }
            CloseableHttpClient closeableHttpClient = this.eventMeshHTTPServer.httpClientPool.getClient();
            String remoteResult = RemoteUnSubscribeEventProcessor.post(closeableHttpClient, targetMesh, remoteHeaderMap, remoteBodyMap, (ResponseHandler<String>)((ResponseHandler)response -> EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Constants.DEFAULT_CHARSET)));
            Map remoteResultMap = (Map)JsonUtils.deserialize((String)remoteResult, (TypeReference)new TypeReference<Map<String, String>>(){});
            if (String.valueOf(EventMeshRetCode.SUCCESS.getRetCode()).equals(remoteResultMap.get("retCode"))) {
                responseBodyMap.put("retCode", EventMeshRetCode.SUCCESS.getRetCode());
                responseBodyMap.put("retMsg", EventMeshRetCode.SUCCESS.getErrMsg());
                handlerSpecific.sendResponse(responseHeaderMap, responseBodyMap);
            } else {
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR, responseHeaderMap, responseBodyMap, null);
            }
        }
        catch (Exception e) {
            long endTime = System.currentTimeMillis();
            this.httpLogger.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, unSubscribeUrl, e});
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR, responseHeaderMap, responseBodyMap, null);
        }
    }

    @Override
    public String[] paths() {
        return new String[]{RequestURI.UNSUBSCRIBE_REMOTE.getRequestURI()};
    }

    public static String post(CloseableHttpClient client, String uri, Map<String, String> requestHeader, Map<String, Object> requestBody, ResponseHandler<String> responseHandler) throws IOException {
        Preconditions.checkState((client != null ? 1 : 0) != 0, (Object)"client can't be null");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)uri), (Object)"uri can't be null");
        Preconditions.checkState((requestHeader != null ? 1 : 0) != 0, (Object)"requestParam can't be null");
        Preconditions.checkState((responseHandler != null ? 1 : 0) != 0, (Object)"responseHandler can't be null");
        HttpPost httpPost = new HttpPost(uri);
        httpPost.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        if (MapUtils.isNotEmpty(requestHeader)) {
            for (Map.Entry<String, String> entry : requestHeader.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (MapUtils.isNotEmpty(requestBody)) {
            String jsonStr = JsonUtils.serialize(requestBody);
            httpPost.setEntity((HttpEntity)new StringEntity(jsonStr, ContentType.APPLICATION_JSON));
        }
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setSocketTimeout(Integer.parseInt(String.valueOf(15000))).setConnectTimeout(Integer.parseInt(String.valueOf(15000))).setConnectionRequestTimeout(Integer.parseInt(String.valueOf(15000)));
        httpPost.setConfig(configBuilder.build());
        return (String)client.execute((HttpUriRequest)httpPost, responseHandler);
    }
}

