/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageBatchResponseBody;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageBatchRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageBatchResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSendMessageProcessor
implements HttpRequestProcessor {
    public Logger cmdLogger = LoggerFactory.getLogger((String)"cmd");
    public Logger aclLogger = LoggerFactory.getLogger((String)"acl");
    private EventMeshHTTPServer eventMeshHTTPServer;
    public Logger batchMessageLogger = LoggerFactory.getLogger((String)"batchMessage");

    public BatchSendMessageProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    @Override
    public void processRequest(ChannelHandlerContext ctx, AsyncContext<HttpCommand> asyncContext) throws Exception {
        this.cmdLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtils.getLocalAddress()});
        SendMessageBatchRequestHeader sendMessageBatchRequestHeader = (SendMessageBatchRequestHeader)asyncContext.getRequest().getHeader();
        SendMessageBatchResponseHeader sendMessageBatchResponseHeader = SendMessageBatchResponseHeader.buildHeader((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode()), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster, (String)IPUtils.getLocalAddress(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        String protocolType = sendMessageBatchRequestHeader.getProtocolType();
        ProtocolAdaptor httpCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        List eventList = httpCommandProtocolAdaptor.toBatchCloudEvent((ProtocolTransportObject)asyncContext.getRequest());
        if (CollectionUtils.isEmpty((Collection)eventList)) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        String batchId = "";
        String producerGroup = "";
        int eventSize = eventList.size();
        if (eventSize > this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventBatchSize) {
            this.batchMessageLogger.error("Event batch size exceeds the limit: {}", (Object)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventBatchSize);
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)("Event batch size exceeds the limit: " + this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventBatchSize)));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        for (CloudEvent event : eventList) {
            String content;
            if (StringUtils.isBlank((CharSequence)event.getId()) || event.getSource() == null || event.getSpecVersion() == null || StringUtils.isBlank((CharSequence)event.getType()) || StringUtils.isBlank((CharSequence)event.getSubject())) {
                HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
                asyncContext.onComplete(responseEventMeshCommand);
                return;
            }
            String string = content = event.getData() == null ? "" : new String(event.getData().toBytes(), StandardCharsets.UTF_8);
            if (content.length() > this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize) {
                this.batchMessageLogger.error("Event size exceeds the limit: {}", (Object)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize);
                HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)("Event size exceeds the limit: " + this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize)));
                asyncContext.onComplete(responseEventMeshCommand);
                return;
            }
            String idc = Objects.requireNonNull(event.getExtension("idc")).toString();
            String pid = Objects.requireNonNull(event.getExtension("pid")).toString();
            String sys = Objects.requireNonNull(event.getExtension("sys")).toString();
            if (StringUtils.isBlank((CharSequence)idc) || StringUtils.isBlank((CharSequence)pid) || !StringUtils.isNumeric((CharSequence)pid) || StringUtils.isBlank((CharSequence)sys)) {
                HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
                asyncContext.onComplete(responseEventMeshCommand);
                return;
            }
            batchId = Objects.requireNonNull(event.getExtension("batchId")).toString();
            producerGroup = Objects.requireNonNull(event.getExtension("producerGroup")).toString();
            eventSize = Integer.parseInt(Objects.requireNonNull(event.getExtension("size")).toString());
            CloudEventData eventData = event.getData();
            if (eventData == null && !StringUtils.isBlank((CharSequence)batchId) && !StringUtils.isBlank((CharSequence)producerGroup) && eventSize == eventList.size()) continue;
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        if (!this.eventMeshHTTPServer.getBatchRateLimiter().tryAcquire(eventSize, 100L, TimeUnit.MILLISECONDS)) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_BATCH_SPEED_OVER_LIMIT_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_BATCH_SPEED_OVER_LIMIT_ERR.getErrMsg()));
            this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendBatchMsgDiscard((long)eventSize);
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        EventMeshProducer batchEventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        batchEventMeshProducer.getMqProducerWrapper().getMeshMQProducer().setExtFields();
        if (!batchEventMeshProducer.getStarted().get()) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_BATCH_PRODUCER_STOPED_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_BATCH_PRODUCER_STOPED_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        long batchStartTime = System.currentTimeMillis();
        String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        int requestCode = Integer.parseInt(asyncContext.getRequest().getRequestCode());
        ConcurrentHashMap topicBatchMessageMappings = new ConcurrentHashMap();
        for (CloudEvent cloudEvent : eventList) {
            if (StringUtils.isBlank((CharSequence)cloudEvent.getSubject()) || cloudEvent.getData() == null) continue;
            Iterator user = Objects.requireNonNull(cloudEvent.getExtension("username")).toString();
            String pass = Objects.requireNonNull(cloudEvent.getExtension("passwd")).toString();
            String subsystem = Objects.requireNonNull(cloudEvent.getExtension("sys")).toString();
            if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerSecurityEnable) {
                try {
                    Acl.doAclCheckInHttpSend(remoteAddr, user, pass, subsystem, cloudEvent.getSubject(), requestCode);
                }
                catch (Exception e) {
                    HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_ACL_ERR.getRetCode(), (String)e.getMessage()));
                    asyncContext.onComplete(responseEventMeshCommand);
                    this.aclLogger.warn("CLIENT HAS NO PERMISSION,BatchSendMessageProcessor send failed", (Throwable)e);
                    return;
                }
            }
            try {
                String ttl = Objects.requireNonNull(cloudEvent.getExtension("ttl")).toString();
                if (StringUtils.isBlank((CharSequence)ttl) || !StringUtils.isNumeric((CharSequence)ttl)) {
                    cloudEvent = CloudEventBuilder.from((CloudEvent)cloudEvent).withExtension("ttl", String.valueOf(EventMeshConstants.DEFAULT_MSG_TTL_MILLS)).withExtension("msgtype", "persistent").build();
                }
                if (topicBatchMessageMappings.containsKey(cloudEvent.getSubject())) {
                    ((List)topicBatchMessageMappings.get(cloudEvent.getSubject())).add(cloudEvent);
                } else {
                    ArrayList<CloudEvent> tmp = new ArrayList<CloudEvent>();
                    tmp.add(cloudEvent);
                    topicBatchMessageMappings.put(cloudEvent.getSubject(), tmp);
                }
                if (!this.batchMessageLogger.isDebugEnabled()) continue;
                this.batchMessageLogger.debug("msg2MQMsg suc, event:{}", (Object)cloudEvent.getData());
            }
            catch (Exception e) {
                this.batchMessageLogger.error("msg2MQMsg err, event:{}", (Object)cloudEvent.getData(), (Object)e);
            }
        }
        if (CollectionUtils.isEmpty((Collection)eventList)) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        long delta = eventSize;
        this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendBatchMsg(delta);
        if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerBatchMsgBatchEnabled) {
            for (List eventlist : topicBatchMessageMappings.values()) {
                CloudEvent event = null;
                final SendMessageContext sendMessageContext = new SendMessageContext(batchId, event, batchEventMeshProducer, this.eventMeshHTTPServer);
                sendMessageContext.setEventList(eventlist);
                batchEventMeshProducer.send(sendMessageContext, new SendCallback(){

                    public void onSuccess(SendResult sendResult) {
                    }

                    public void onException(OnExceptionContext context) {
                        BatchSendMessageProcessor.this.batchMessageLogger.warn("", (Throwable)context.getException());
                        BatchSendMessageProcessor.this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
                    }
                });
            }
        } else {
            for (CloudEvent event : eventList) {
                final SendMessageContext sendMessageContext = new SendMessageContext(batchId, event, batchEventMeshProducer, this.eventMeshHTTPServer);
                batchEventMeshProducer.send(sendMessageContext, new SendCallback(){

                    public void onSuccess(SendResult sendResult) {
                    }

                    public void onException(OnExceptionContext context) {
                        BatchSendMessageProcessor.this.batchMessageLogger.warn("", (Throwable)context.getException());
                        BatchSendMessageProcessor.this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
                    }
                });
            }
        }
        long batchEndTime = System.currentTimeMillis();
        this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordBatchSendMsgCost(batchEndTime - batchStartTime);
        this.batchMessageLogger.debug("batchMessage|eventMesh2mq|REQ|ASYNC|batchId={}|send2MQCost={}ms|msgNum={}|topics={}", new Object[]{batchId, batchEndTime - batchStartTime, eventSize, topicBatchMessageMappings.keySet()});
        HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchResponseHeader, (Body)SendMessageBatchResponseBody.buildBody((Integer)EventMeshRetCode.SUCCESS.getRetCode(), (String)EventMeshRetCode.SUCCESS.getErrMsg()));
        asyncContext.onComplete(responseEventMeshCommand);
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

