/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.service;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.protocol.grpc.protos.BatchMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.Heartbeat;
import org.apache.eventmesh.common.protocol.grpc.protos.RequestHeader;
import org.apache.eventmesh.common.protocol.grpc.protos.Response;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.GrpcType;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;

public class ServiceUtils {
    public static boolean validateHeader(RequestHeader header) {
        return StringUtils.isNotEmpty((CharSequence)header.getIdc()) && StringUtils.isNotEmpty((CharSequence)header.getEnv()) && StringUtils.isNotEmpty((CharSequence)header.getIp()) && StringUtils.isNotEmpty((CharSequence)header.getPid()) && StringUtils.isNumeric((CharSequence)header.getPid()) && StringUtils.isNotEmpty((CharSequence)header.getSys()) && StringUtils.isNotEmpty((CharSequence)header.getUsername()) && StringUtils.isNotEmpty((CharSequence)header.getPassword()) && StringUtils.isNotEmpty((CharSequence)header.getLanguage());
    }

    public static boolean validateMessage(SimpleMessage message) {
        return StringUtils.isNotEmpty((CharSequence)message.getUniqueId()) && StringUtils.isNotEmpty((CharSequence)message.getProducerGroup()) && StringUtils.isNotEmpty((CharSequence)message.getTopic()) && StringUtils.isNotEmpty((CharSequence)message.getContent()) && StringUtils.isNotEmpty((CharSequence)message.getTtl());
    }

    public static boolean validateBatchMessage(BatchMessage batchMessage) {
        if (StringUtils.isEmpty((CharSequence)batchMessage.getTopic()) || StringUtils.isEmpty((CharSequence)batchMessage.getProducerGroup())) {
            return false;
        }
        for (BatchMessage.MessageItem item : batchMessage.getMessageItemList()) {
            if (!StringUtils.isEmpty((CharSequence)item.getContent()) && !StringUtils.isEmpty((CharSequence)item.getSeqNum()) && !StringUtils.isEmpty((CharSequence)item.getTtl()) && !StringUtils.isEmpty((CharSequence)item.getUniqueId())) continue;
            return false;
        }
        return true;
    }

    public static boolean validateSubscription(GrpcType grpcType, Subscription subscription) {
        if (GrpcType.WEBHOOK.equals((Object)grpcType) && StringUtils.isEmpty((CharSequence)subscription.getUrl())) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)subscription.getSubscriptionItemsList()) || StringUtils.isEmpty((CharSequence)subscription.getConsumerGroup())) {
            return false;
        }
        for (Subscription.SubscriptionItem item : subscription.getSubscriptionItemsList()) {
            if (!StringUtils.isEmpty((CharSequence)item.getTopic()) && item.getMode() != Subscription.SubscriptionItem.SubscriptionMode.UNRECOGNIZED && item.getType() != Subscription.SubscriptionItem.SubscriptionType.UNRECOGNIZED) continue;
            return false;
        }
        return true;
    }

    public static boolean validateHeartBeat(Heartbeat heartbeat) {
        if (Heartbeat.ClientType.SUB.equals((Object)heartbeat.getClientType()) && StringUtils.isEmpty((CharSequence)heartbeat.getConsumerGroup())) {
            return false;
        }
        if (Heartbeat.ClientType.PUB.equals((Object)heartbeat.getClientType()) && StringUtils.isEmpty((CharSequence)heartbeat.getProducerGroup())) {
            return false;
        }
        for (Heartbeat.HeartbeatItem item : heartbeat.getHeartbeatItemsList()) {
            if (!StringUtils.isEmpty((CharSequence)item.getTopic())) continue;
            return false;
        }
        return true;
    }

    public static void sendRespAndDone(StatusCode code, EventEmitter<Response> emitter) {
        Response response = Response.newBuilder().setRespCode(code.getRetCode()).setRespMsg(code.getErrMsg()).setRespTime(String.valueOf(System.currentTimeMillis())).build();
        emitter.onNext(response);
        emitter.onCompleted();
    }

    public static void sendRespAndDone(StatusCode code, String message, EventEmitter<Response> emitter) {
        Response response = Response.newBuilder().setRespCode(code.getRetCode()).setRespMsg(code.getErrMsg() + " " + message).setRespTime(String.valueOf(System.currentTimeMillis())).build();
        emitter.onNext(response);
        emitter.onCompleted();
    }

    public static void sendStreamResp(RequestHeader header, StatusCode code, String message, EventEmitter<SimpleMessage> emitter) {
        HashMap<String, Object> resp = new HashMap<String, Object>();
        resp.put("respCode", code.getRetCode());
        resp.put("respMsg", code.getErrMsg() + " " + message);
        SimpleMessage simpleMessage = SimpleMessage.newBuilder().setHeader(header).setContent(JsonUtils.serialize(resp)).build();
        emitter.onNext(simpleMessage);
    }

    public static void sendStreamRespAndDone(RequestHeader header, StatusCode code, String message, EventEmitter<SimpleMessage> emitter) {
        ServiceUtils.sendStreamResp(header, code, message, emitter);
        emitter.onCompleted();
    }

    public static void sendStreamRespAndDone(RequestHeader header, StatusCode code, EventEmitter<SimpleMessage> emitter) {
        HashMap<String, String> resp = new HashMap<String, String>();
        resp.put("respCode", code.getRetCode());
        resp.put("respMsg", code.getErrMsg());
        SimpleMessage simpleMessage = SimpleMessage.newBuilder().setHeader(header).setContent(JsonUtils.serialize(resp)).build();
        emitter.onNext(simpleMessage);
        emitter.onCompleted();
    }
}

