/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.push;

import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.StreamTopicConfig;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.AbstractPushRequest;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamPushRequest
extends AbstractPushRequest {
    private final Logger messageLogger = LoggerFactory.getLogger((String)"message");
    private final Map<String, List<EventEmitter<SimpleMessage>>> idcEmitters;
    private final List<EventEmitter<SimpleMessage>> totalEmitters;
    private final Subscription.SubscriptionItem.SubscriptionMode subscriptionMode;
    private final int startIdx;

    public StreamPushRequest(HandleMsgContext handleMsgContext, Map<String, Set<AbstractPushRequest>> waitingRequests) {
        super(handleMsgContext, waitingRequests);
        StreamTopicConfig topicConfig = (StreamTopicConfig)handleMsgContext.getConsumeTopicConfig();
        this.idcEmitters = topicConfig.getIdcEmitters();
        this.totalEmitters = topicConfig.getTotalEmitters();
        this.subscriptionMode = topicConfig.getSubscriptionMode();
        this.startIdx = RandomUtils.nextInt((int)0, (int)this.totalEmitters.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryPushRequest() {
        if (this.simpleMessage == null) {
            return;
        }
        List<EventEmitter<SimpleMessage>> eventEmitters = this.selectEmitter();
        for (EventEmitter<SimpleMessage> eventEmitter : eventEmitters) {
            long cost;
            this.lastPushTime = System.currentTimeMillis();
            this.simpleMessage = SimpleMessage.newBuilder((SimpleMessage)this.simpleMessage).putProperties("reqeventmesh2ctimestamp", String.valueOf(this.lastPushTime)).build();
            try {
                StreamObserver<SimpleMessage> emitter;
                StreamObserver<SimpleMessage> streamObserver = emitter = eventEmitter.getEmitter();
                synchronized (streamObserver) {
                    emitter.onNext((Object)this.simpleMessage);
                }
                cost = System.currentTimeMillis() - this.lastPushTime;
                this.messageLogger.info("message|eventMesh2client|emitter|topic={}|bizSeqNo={}|uniqueId={}|cost={}", new Object[]{this.simpleMessage.getTopic(), this.simpleMessage.getSeqNum(), this.simpleMessage.getUniqueId(), cost});
                this.complete();
            }
            catch (Throwable t) {
                cost = System.currentTimeMillis() - this.lastPushTime;
                this.messageLogger.error("message|eventMesh2client|exception={} |emitter|topic={}|bizSeqNo={}|uniqueId={}|cost={}", new Object[]{t.getMessage(), this.simpleMessage.getTopic(), this.simpleMessage.getSeqNum(), this.simpleMessage.getUniqueId(), cost, t});
                this.delayRetry();
            }
        }
    }

    private List<EventEmitter<SimpleMessage>> selectEmitter() {
        List emitterList = (List)MapUtils.getObject(this.idcEmitters, (Object)this.eventMeshGrpcConfiguration.eventMeshIDC, null);
        if (CollectionUtils.isNotEmpty((Collection)emitterList)) {
            if (this.subscriptionMode.equals((Object)Subscription.SubscriptionItem.SubscriptionMode.CLUSTERING)) {
                return Collections.singletonList((EventEmitter)emitterList.get((this.startIdx + this.retryTimes) % emitterList.size()));
            }
            if (this.subscriptionMode.equals((Object)Subscription.SubscriptionItem.SubscriptionMode.BROADCASTING)) {
                return emitterList;
            }
            this.messageLogger.error("Invalid Subscription Mode, no message returning back to subscriber.");
            return Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty(this.totalEmitters)) {
            if (this.subscriptionMode.equals((Object)Subscription.SubscriptionItem.SubscriptionMode.CLUSTERING)) {
                return Collections.singletonList(this.totalEmitters.get((this.startIdx + this.retryTimes) % this.totalEmitters.size()));
            }
            if (this.subscriptionMode.equals((Object)Subscription.SubscriptionItem.SubscriptionMode.BROADCASTING)) {
                return this.totalEmitters;
            }
            this.messageLogger.error("Invalid Subscription Mode, no message returning back to subscriber.");
            return Collections.emptyList();
        }
        this.messageLogger.error("No event emitters from subscriber, no message returning.");
        return Collections.emptyList();
    }
}

