/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.configuration;

import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigurationWrapper;

public class EventMeshTCPConfiguration
extends CommonConfiguration {
    public int eventMeshTcpServerPort = 10000;
    public int eventMeshTcpIdleAllSeconds = 60;
    public int eventMeshTcpIdleWriteSeconds = 60;
    public int eventMeshTcpIdleReadSeconds = 60;
    public Integer eventMeshTcpMsgReqnumPerSecond = 15000;
    public int eventMeshTcpClientMaxNum = 10000;
    public int eventMeshTcpGlobalScheduler = 5;
    public int eventMeshTcpTaskHandleExecutorPoolSize = Runtime.getRuntime().availableProcessors();
    public int eventMeshTcpMsgDownStreamExecutorPoolSize = Math.max(Runtime.getRuntime().availableProcessors(), 8);
    public int eventMeshTcpSessionExpiredInMills = 60000;
    public int eventMeshTcpSessionUpstreamBufferSize = 100;
    public int eventMeshTcpMsgAsyncRetryTimes = 3;
    public int eventMeshTcpMsgSyncRetryTimes = 1;
    public int eventMeshTcpMsgRetrySyncDelayInMills = 500;
    public int eventMeshTcpMsgRetryAsyncDelayInMills = 500;
    public int eventMeshTcpMsgRetryQueueSize = 10000;
    public Integer eventMeshTcpRebalanceIntervalInMills = 30000;
    public int eventMeshServerAdminPort = 10106;
    public boolean eventMeshTcpSendBackEnabled = Boolean.TRUE;
    public int eventMeshTcpSendBackMaxTimes = 3;
    public int eventMeshTcpPushFailIsolateTimeInMills = 30000;
    public int gracefulShutdownSleepIntervalInMills = 1000;
    public int sleepIntervalInRebalanceRedirectMills = 200;
    public int eventMeshEventSize = 1000;
    public int eventMeshEventBatchSize = 10;
    private TrafficShapingConfig gtc = new TrafficShapingConfig(0L, 10000L, 1000L, 2000L);
    private TrafficShapingConfig ctc = new TrafficShapingConfig(0L, 2000L, 1000L, 10000L);

    public EventMeshTCPConfiguration(ConfigurationWrapper configurationWrapper) {
        super(configurationWrapper);
    }

    public void init() {
        super.init();
        this.eventMeshTcpServerPort = this.configurationWrapper.getIntProp("eventMesh.server.tcp.port", this.eventMeshTcpServerPort);
        this.eventMeshTcpIdleReadSeconds = this.configurationWrapper.getIntProp("eventMesh.server.tcp.readerIdleSeconds", this.eventMeshTcpIdleReadSeconds);
        this.eventMeshTcpIdleWriteSeconds = this.configurationWrapper.getIntProp("eventMesh.server.tcp.writerIdleSeconds", this.eventMeshTcpIdleWriteSeconds);
        this.eventMeshTcpIdleAllSeconds = this.configurationWrapper.getIntProp("eventMesh.server.tcp.allIdleSeconds", this.eventMeshTcpIdleAllSeconds);
        this.eventMeshTcpMsgReqnumPerSecond = this.configurationWrapper.getIntProp("eventMesh.server.tcp.msgReqnumPerSecond", this.eventMeshTcpMsgReqnumPerSecond.intValue());
        this.eventMeshTcpClientMaxNum = this.configurationWrapper.getIntProp("eventMesh.server.tcp.clientMaxNum", this.eventMeshTcpClientMaxNum);
        this.eventMeshTcpGlobalScheduler = this.configurationWrapper.getIntProp("eventMesh.server.global.scheduler", this.eventMeshTcpGlobalScheduler);
        this.eventMeshTcpTaskHandleExecutorPoolSize = this.configurationWrapper.getIntProp("eventMesh.server.tcp.taskHandleExecutorPoolSize", this.eventMeshTcpTaskHandleExecutorPoolSize);
        this.eventMeshTcpMsgDownStreamExecutorPoolSize = this.configurationWrapper.getIntProp("eventMesh.server.tcp.msgDownStreamExecutorPoolSize", this.eventMeshTcpMsgDownStreamExecutorPoolSize);
        this.eventMeshTcpSessionExpiredInMills = this.configurationWrapper.getIntProp("eventMesh.server.session.expiredInMills", this.eventMeshTcpSessionExpiredInMills);
        this.eventMeshTcpSessionUpstreamBufferSize = this.configurationWrapper.getIntProp("eventMesh.server.session.upstreamBufferSize", this.eventMeshTcpSessionUpstreamBufferSize);
        this.eventMeshTcpMsgAsyncRetryTimes = this.configurationWrapper.getIntProp("eventMesh.server.retry.async.pushRetryTimes", this.eventMeshTcpMsgAsyncRetryTimes);
        this.eventMeshTcpMsgSyncRetryTimes = this.configurationWrapper.getIntProp("eventMesh.server.retry.sync.pushRetryTimes", this.eventMeshTcpMsgSyncRetryTimes);
        this.eventMeshTcpMsgRetryAsyncDelayInMills = this.configurationWrapper.getIntProp("eventMesh.server.retry.async.pushRetryDelayInMills", this.eventMeshTcpMsgRetryAsyncDelayInMills);
        this.eventMeshTcpMsgRetrySyncDelayInMills = this.configurationWrapper.getIntProp("eventMesh.server.retry.sync.pushRetryDelayInMills", this.eventMeshTcpMsgRetrySyncDelayInMills);
        this.eventMeshTcpMsgRetryQueueSize = this.configurationWrapper.getIntProp("eventMesh.server.retry.pushRetryQueueSize", this.eventMeshTcpMsgRetryQueueSize);
        this.eventMeshTcpRebalanceIntervalInMills = this.configurationWrapper.getIntProp("eventMesh.server.tcp.RebalanceIntervalInMills", this.eventMeshTcpRebalanceIntervalInMills.intValue());
        this.eventMeshServerAdminPort = this.configurationWrapper.getIntProp("eventMesh.server.admin.http.port", this.eventMeshServerAdminPort);
        this.eventMeshTcpSendBackEnabled = this.configurationWrapper.getBoolProp("eventMesh.server.tcp.sendBack.enabled", this.eventMeshTcpSendBackEnabled);
        this.eventMeshTcpPushFailIsolateTimeInMills = this.configurationWrapper.getIntProp("eventMesh.server.tcp.pushFailIsolateTimeInMills", this.eventMeshTcpPushFailIsolateTimeInMills);
        this.gracefulShutdownSleepIntervalInMills = this.configurationWrapper.getIntProp("eventMesh.server.gracefulShutdown.sleepIntervalInMills", this.gracefulShutdownSleepIntervalInMills);
        this.sleepIntervalInRebalanceRedirectMills = this.configurationWrapper.getIntProp("eventMesh.server.rebalanceRedirect.sleepIntervalInM", this.sleepIntervalInRebalanceRedirectMills);
        this.eventMeshEventSize = this.configurationWrapper.getIntProp("eventMesh.server.maxEventSize", this.eventMeshEventSize);
        this.eventMeshEventBatchSize = this.configurationWrapper.getIntProp("eventMesh.server.maxEventBatchSize", this.eventMeshEventBatchSize);
    }

    public TrafficShapingConfig getGtc() {
        return this.gtc;
    }

    public TrafficShapingConfig getCtc() {
        return this.ctc;
    }

    public static class TrafficShapingConfig {
        long writeLimit = 0L;
        long readLimit = 1000L;
        long checkInterval = 1000L;
        long maxTime = 5000L;

        public TrafficShapingConfig(long writeLimit, long readLimit, long checkInterval, long maxTime) {
            this.writeLimit = writeLimit;
            this.readLimit = readLimit;
            this.checkInterval = checkInterval;
            this.maxTime = maxTime;
        }

        public TrafficShapingConfig() {
        }

        public long getWriteLimit() {
            return this.writeLimit;
        }

        public void setWriteLimit(long writeLimit) {
            this.writeLimit = writeLimit;
        }

        public long getReadLimit() {
            return this.readLimit;
        }

        public void setReadLimit(long readLimit) {
            this.readLimit = readLimit;
        }

        public long getCheckInterval() {
            return this.checkInterval;
        }

        public void setCheckInterval(long checkInterval) {
            this.checkInterval = checkInterval;
        }

        public long getMaxTime() {
            return this.maxTime;
        }

        public void setMaxTime(long maxTime) {
            this.maxTime = maxTime;
        }

        public String toString() {
            return "TrafficShapingConfig{writeLimit=" + this.writeLimit + ", readLimit=" + this.readLimit + ", checkInterval=" + this.checkInterval + ", maxTime=" + this.maxTime + "}";
        }
    }

    static class ConfKeys {
        public static final String KEYS_EVENTMESH_SERVER_TCP_PORT = "eventMesh.server.tcp.port";
        public static final String KEYS_EVENTMESH_SERVER_READER_IDLE_SECONDS = "eventMesh.server.tcp.readerIdleSeconds";
        public static final String KEYS_EVENTMESH_SERVER_WRITER_IDLE_SECONDS = "eventMesh.server.tcp.writerIdleSeconds";
        public static final String KEYS_EVENTMESH_SERVER_ALL_IDLE_SECONDS = "eventMesh.server.tcp.allIdleSeconds";
        public static final String KEYS_EVENTMESH_SERVER_CLIENT_MAX_NUM = "eventMesh.server.tcp.clientMaxNum";
        public static final String KEYS_EVENTMESH_SERVER_MSG_REQ_NUM_PER_SECONDS = "eventMesh.server.tcp.msgReqnumPerSecond";
        public static final String KEYS_EVENTMESH_SERVER_TCP_REBALANCE_INTERVAL = "eventMesh.server.tcp.RebalanceIntervalInMills";
        public static final String KEYS_EVENTMESH_SERVER_GLOBAL_SCHEDULER = "eventMesh.server.global.scheduler";
        public static final String KEYS_EVENTMESH_SERVER_TCP_TASK_HANDLE_POOL_SIZE = "eventMesh.server.tcp.taskHandleExecutorPoolSize";
        public static final String KEYS_EVENTMESH_SERVER_TCP_MSG_DOWNSTREAM_POOL_SIZE = "eventMesh.server.tcp.msgDownStreamExecutorPoolSize";
        public static final String KEYS_EVENTMESH_SERVER_SESSION_EXPIRED_TIME = "eventMesh.server.session.expiredInMills";
        public static final String KEYS_EVENTMESH_SERVER_SESSION_UPSTREAM_BUFFER_SIZE = "eventMesh.server.session.upstreamBufferSize";
        public static final String KEYS_EVENTMESH_SERVER_SESSION_DOWNSTREAM_UNACK_SIZE = "eventMesh.server.session.downstreamUnackSize";
        public static final String KEYS_EVENTMESH_SERVER_RETRY_ASYNC_PUSH_RETRY_TIMES = "eventMesh.server.retry.async.pushRetryTimes";
        public static final String KEYS_EVENTMESH_SERVER_RETRY_SYNC_PUSH_RETRY_TIMES = "eventMesh.server.retry.sync.pushRetryTimes";
        public static final String KEYS_EVENTMESH_SERVER_RETRY_ASYNC_PUSH_RETRY_DELAY = "eventMesh.server.retry.async.pushRetryDelayInMills";
        public static final String KEYS_EVENTMESH_SERVER_RETRY_SYNC_PUSH_RETRY_DELAY = "eventMesh.server.retry.sync.pushRetryDelayInMills";
        public static final String KEYS_EVENTMESH_SERVER_RETRY_PUSH_RETRY_QUEUE_SIZE = "eventMesh.server.retry.pushRetryQueueSize";
        public static final String KEYS_EVENTMESH_SERVER_ADMIN_HTTP_PORT = "eventMesh.server.admin.http.port";
        public static final String KEYS_EVENTMESH_TCP_SEND_BACK_ENABLED = "eventMesh.server.tcp.sendBack.enabled";
        public static final String KEYS_EVENTMESH_SERVER_PUSH_FAIL_ISOLATE_TIME = "eventMesh.server.tcp.pushFailIsolateTimeInMills";
        public static final String KEYS_EVENTMESH_SERVER_GRACEFUL_SHUTDOWN_SLEEP_TIME = "eventMesh.server.gracefulShutdown.sleepIntervalInMills";
        public static final String KEYS_EVENTMESH_SERVER_REBALANCE_REDIRECT_SLEEP_TIME = "eventMesh.server.rebalanceRedirect.sleepIntervalInM";
        public static final String KEYS_EVENTMESH_SERVER_EVENTSIZE = "eventMesh.server.maxEventSize";
        public static final String KEYS_EVENTMESH_SERVER_EVENT_BATCHSIZE = "eventMesh.server.maxEventBatchSize";

        ConfKeys() {
        }
    }
}

