/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextFactory {
    private static Logger httpLogger = LoggerFactory.getLogger((String)"http");
    private static String protocol = "TLSv1.1";
    private static String fileName;
    private static String pass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLContext getSslContext(EventMeshHTTPConfiguration eventMeshHttpConfiguration) {
        SSLContext sslContext;
        InputStream inputStream = null;
        try {
            protocol = eventMeshHttpConfiguration.eventMeshServerSSLProtocol;
            fileName = eventMeshHttpConfiguration.eventMeshServerSSLCer;
            char[] filePass = null;
            pass = eventMeshHttpConfiguration.eventMeshServerSSLPass;
            if (StringUtils.isNotBlank((CharSequence)pass)) {
                filePass = pass.toCharArray();
            }
            sslContext = SSLContext.getInstance(protocol);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            inputStream = Files.newInputStream(Paths.get(EventMeshConstants.EVENTMESH_CONF_HOME + File.separator + fileName, new String[0]), StandardOpenOption.READ);
            keyStore.load(inputStream, filePass);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, filePass);
            sslContext.init(kmf.getKeyManagers(), null, null);
        }
        catch (Exception e) {
            httpLogger.warn("sslContext init failed", (Throwable)e);
            sslContext = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    httpLogger.warn("IOException found", (Throwable)e);
                }
            }
        }
        return sslContext;
    }
}

