/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.MapWriterTask;
import org.redisson.RedissonObject;
import org.redisson.RedissonQueue;
import org.redisson.api.MapOptions;
import org.redisson.api.RFuture;
import org.redisson.api.RQueue;
import org.redisson.command.CommandAsyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapWriteBehindTask {
    private static final Logger log = LoggerFactory.getLogger(MapWriteBehindTask.class);
    private final AtomicBoolean isStarted = new AtomicBoolean();
    private final RQueue<MapWriterTask> writeBehindTasks;
    private final CommandAsyncExecutor commandExecutor;
    private final MapOptions<Object, Object> options;

    public MapWriteBehindTask(String name, CommandAsyncExecutor commandExecutor, MapOptions<?, ?> options) {
        this.commandExecutor = commandExecutor;
        this.options = options;
        String queueName = RedissonObject.suffixName(name, "write-behind-queue");
        this.writeBehindTasks = new RedissonQueue<MapWriterTask>(commandExecutor, queueName, null);
    }

    public void start() {
        if (!this.isStarted.compareAndSet(false, true)) {
            return;
        }
        this.enqueueTask();
    }

    private void pollTask(Map<Object, Object> addedMap, List<Object> deletedKeys) {
        RFuture future = this.writeBehindTasks.pollAsync();
        future.whenComplete((task, e) -> {
            if (e != null) {
                log.error(e.getMessage(), e);
                this.enqueueTask();
                return;
            }
            this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                if (task != null) {
                    this.processTask(addedMap, deletedKeys, (MapWriterTask)task);
                    this.pollTask(addedMap, deletedKeys);
                } else {
                    this.flushTasks(addedMap, deletedKeys);
                    this.enqueueTask();
                }
            });
        });
    }

    private void flushTasks(Map<Object, Object> addedMap, List<Object> deletedKeys) {
        try {
            if (!deletedKeys.isEmpty()) {
                this.options.getWriter().delete(deletedKeys);
                deletedKeys.clear();
            }
        }
        catch (Exception exception) {
            log.error("Unable to delete keys: " + deletedKeys, (Throwable)exception);
        }
        try {
            if (!addedMap.isEmpty()) {
                this.options.getWriter().write(addedMap);
                addedMap.clear();
            }
        }
        catch (Exception exception) {
            log.error("Unable to add keys: " + addedMap, (Throwable)exception);
        }
    }

    private void processTask(Map<Object, Object> addedMap, List<Object> deletedKeys, MapWriterTask task) {
        if (task instanceof MapWriterTask.Remove) {
            for (Object key : task.getKeys()) {
                try {
                    deletedKeys.add(key);
                    if (deletedKeys.size() != this.options.getWriteBehindBatchSize()) continue;
                    this.options.getWriter().delete(deletedKeys);
                    deletedKeys.clear();
                }
                catch (Exception exception) {
                    log.error("Unable to delete keys: " + deletedKeys, (Throwable)exception);
                }
            }
        } else {
            for (Map.Entry entry : task.getMap().entrySet()) {
                try {
                    addedMap.put(entry.getKey(), entry.getValue());
                    if (addedMap.size() != this.options.getWriteBehindBatchSize()) continue;
                    this.options.getWriter().write(addedMap);
                    addedMap.clear();
                }
                catch (Exception exception) {
                    log.error("Unable to add keys: " + addedMap, (Throwable)exception);
                }
            }
        }
    }

    private void enqueueTask() {
        if (!this.isStarted.get()) {
            return;
        }
        this.commandExecutor.getConnectionManager().newTimeout(t -> {
            LinkedHashMap<Object, Object> addedMap = new LinkedHashMap<Object, Object>();
            ArrayList<Object> deletedKeys = new ArrayList<Object>();
            this.pollTask(addedMap, deletedKeys);
        }, this.options.getWriteBehindDelay(), TimeUnit.MILLISECONDS);
    }

    public void addTask(MapWriterTask task) {
        this.writeBehindTasks.addAsync(task);
    }

    public void stop() {
        this.isStarted.set(false);
        LinkedHashMap<Object, Object> addedMap = new LinkedHashMap<Object, Object>();
        ArrayList<Object> deletedKeys = new ArrayList<Object>();
        for (MapWriterTask task : this.writeBehindTasks.readAll()) {
            this.processTask(addedMap, deletedKeys, task);
        }
        this.flushTasks(addedMap, deletedKeys);
    }
}

