/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.api.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationWrapper {
    private static Logger logger = LoggerFactory.getLogger((String)"ConfigurationWrapper");
    private static final String EVENTMESH_CONFIG_HOME = System.getProperty("confPath", System.getenv("confPath"));

    public static Properties getConfig(String configFile) {
        URL resource = ConfigurationWrapper.class.getClassLoader().getResource(configFile);
        Object configFilePath = resource != null && new File(resource.getPath()).exists() ? resource.getPath() : EVENTMESH_CONFIG_HOME + File.separator + configFile;
        logger.info("loading auth config: {}", configFilePath);
        Properties properties = new Properties();
        try {
            properties.load(new BufferedReader(new FileReader((String)configFilePath)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Cannot load RocketMQ configuration file from :%s", configFilePath));
        }
        return properties;
    }
}

