/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.trace;

import io.cloudevents.CloudEvent;
import io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.runtime.trace.AttributeKeys;
import org.apache.eventmesh.runtime.trace.SpanKey;
import org.apache.eventmesh.trace.api.EventMeshTraceService;
import org.apache.eventmesh.trace.api.TracePluginFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Trace {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean useTrace;
    private EventMeshTraceService eventMeshTraceService;

    public Trace(boolean useTrace) {
        this.useTrace = useTrace;
    }

    public void init(String tracePluginType) throws Exception {
        if (this.useTrace) {
            this.eventMeshTraceService = TracePluginFactory.getEventMeshTraceService((String)tracePluginType);
            this.eventMeshTraceService.init();
        }
    }

    public Span createSpan(String spanName, SpanKind spanKind, long startTime, TimeUnit timeUnit, Context context, boolean isSpanFinishInOtherThread) {
        if (!this.useTrace) {
            return Span.getInvalid();
        }
        return this.eventMeshTraceService.createSpan(spanName, spanKind, startTime, timeUnit, context, isSpanFinishInOtherThread);
    }

    public Span createSpan(String spanName, SpanKind spanKind, Context context, boolean isSpanFinishInOtherThread) {
        if (!this.useTrace) {
            return Span.getInvalid();
        }
        return this.eventMeshTraceService.createSpan(spanName, spanKind, context, isSpanFinishInOtherThread);
    }

    public Context extractFrom(Context context, Map<String, Object> map) {
        if (!this.useTrace) {
            return null;
        }
        if (map == null) {
            return context;
        }
        return this.eventMeshTraceService.extractFrom(context, map);
    }

    public void inject(Context context, Map<String, Object> map) {
        if (!this.useTrace) {
            return;
        }
        if (context == null || map == null) {
            return;
        }
        this.eventMeshTraceService.inject(context, map);
    }

    public Span addTraceInfoToSpan(ChannelHandlerContext ctx, CloudEvent cloudEvent) {
        Span span;
        if (!this.useTrace) {
            return null;
        }
        Context context = (Context)ctx.channel().attr(AttributeKeys.SERVER_CONTEXT).get();
        Span span2 = span = context != null ? (Span)context.get(SpanKey.SERVER_KEY) : null;
        if (span == null) {
            this.logger.warn("span is null when finishSpan");
            return null;
        }
        Iterator iterator = cloudEvent.getExtensionNames().iterator();
        while (iterator.hasNext()) {
            String entry;
            span.setAttribute(entry, cloudEvent.getExtension(entry = (String)iterator.next()) == null ? "" : cloudEvent.getExtension(entry).toString());
        }
        return span;
    }

    public Span addTraceInfoToSpan(Span span, CloudEvent cloudEvent) {
        if (!this.useTrace) {
            return null;
        }
        if (span == null) {
            this.logger.warn("span is null when finishSpan");
            return null;
        }
        if (cloudEvent == null) {
            return span;
        }
        Iterator iterator = cloudEvent.getExtensionNames().iterator();
        while (iterator.hasNext()) {
            String entry;
            span.setAttribute(entry, cloudEvent.getExtension(entry = (String)iterator.next()) == null ? "" : cloudEvent.getExtension(entry).toString());
        }
        return span;
    }

    public Span addTraceInfoToSpan(Span span, Map<String, Object> map) {
        if (!this.useTrace) {
            return null;
        }
        if (span == null) {
            this.logger.warn("span is null when finishSpan");
            return null;
        }
        if (map == null || map.size() < 1) {
            return span;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            span.setAttribute(entry.getKey(), entry.getValue().toString());
        }
        return span;
    }

    public void finishSpan(ChannelHandlerContext ctx, StatusCode statusCode) {
        try {
            if (this.useTrace) {
                Span span;
                Context context = (Context)ctx.channel().attr(AttributeKeys.SERVER_CONTEXT).get();
                Span span2 = span = context != null ? (Span)context.get(SpanKey.SERVER_KEY) : null;
                if (span == null) {
                    this.logger.warn("span is null when finishSpan");
                    return;
                }
                if (statusCode != null) {
                    span.setStatus(statusCode);
                }
                span.end();
            }
        }
        catch (Exception e) {
            this.logger.warn("finishSpan occur exception,", (Throwable)e);
        }
    }

    public void finishSpan(Span span, StatusCode statusCode) {
        try {
            if (this.useTrace) {
                if (span == null) {
                    this.logger.warn("span is null when finishSpan");
                    return;
                }
                if (statusCode != null) {
                    span.setStatus(statusCode);
                }
                span.end();
            }
        }
        catch (Exception e) {
            this.logger.warn("finishSpan occur exception,", (Throwable)e);
        }
    }

    public void finishSpan(Span span, StatusCode statusCode, String errMsg, Throwable throwable) {
        try {
            if (this.useTrace) {
                if (span == null) {
                    this.logger.warn("span is null when finishSpan");
                    return;
                }
                if (statusCode != null) {
                    span.setStatus(statusCode, errMsg);
                }
                if (throwable != null) {
                    span.recordException(throwable);
                }
                span.end();
            }
        }
        catch (Exception e) {
            this.logger.warn("finishSpan occur exception,", (Throwable)e);
        }
    }

    public void finishSpan(ChannelHandlerContext ctx, StatusCode statusCode, String errMsg, Throwable throwable) {
        try {
            if (this.useTrace) {
                Span span;
                Context context = (Context)ctx.channel().attr(AttributeKeys.SERVER_CONTEXT).get();
                Span span2 = span = context != null ? (Span)context.get(SpanKey.SERVER_KEY) : null;
                if (span == null) {
                    this.logger.warn("span is null when finishSpan");
                    return;
                }
                if (statusCode != null) {
                    span.setStatus(statusCode, errMsg);
                }
                if (throwable != null) {
                    span.recordException(throwable);
                }
                span.end();
            }
        }
        catch (Exception e) {
            this.logger.warn("finishSpan occur exception,", (Throwable)e);
        }
    }

    public void shutdown() throws Exception {
        if (this.useTrace) {
            this.eventMeshTraceService.shutdown();
        }
    }
}

