/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.DownStreamMsgContext;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.SessionPusher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushContext {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private SessionPusher sessionPusher;
    public AtomicLong deliveredMsgsCount = new AtomicLong(0L);
    public AtomicLong deliverFailMsgsCount = new AtomicLong(0L);
    private ConcurrentHashMap<String, DownStreamMsgContext> unAckMsg = new ConcurrentHashMap();
    private long createTime = System.currentTimeMillis();

    public PushContext(SessionPusher sessionPusher) {
        this.sessionPusher = sessionPusher;
    }

    public void deliveredMsgCount() {
        this.deliveredMsgsCount.incrementAndGet();
    }

    public void deliverFailMsgCount() {
        this.deliverFailMsgsCount.incrementAndGet();
    }

    public void unAckMsg(String seq, DownStreamMsgContext downStreamMsgContext) {
        this.unAckMsg.put(seq, downStreamMsgContext);
        this.logger.info("put msg in unAckMsg,seq:{},unAckMsgSize:{}", (Object)seq, (Object)this.getTotalUnackMsgs());
    }

    public int getTotalUnackMsgs() {
        return this.unAckMsg.size();
    }

    public ConcurrentHashMap<String, DownStreamMsgContext> getUnAckMsg() {
        return this.unAckMsg;
    }

    public String toString() {
        return "PushContext{deliveredMsgsCount=" + this.deliveredMsgsCount.longValue() + ",deliverFailCount=" + this.deliverFailMsgsCount.longValue() + ",unAckMsg=" + CollectionUtils.size(this.unAckMsg) + ",createTime=" + DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + "}";
    }
}

