/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session;

import io.cloudevents.CloudEvent;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.SessionContext;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.SessionState;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.DownStreamMsgContext;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.SessionPusher;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendResult;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.SessionSender;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    protected final Logger messageLogger = LoggerFactory.getLogger((String)"message");
    private final Logger subscribeLogger = LoggerFactory.getLogger((String)"subscribeLogger");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private UserAgent client;
    private InetSocketAddress remoteAddress;
    protected ChannelHandlerContext context;
    private WeakReference<ClientGroupWrapper> clientGroupWrapper;
    private EventMeshTCPConfiguration eventMeshTCPConfiguration;
    private SessionPusher pusher;
    private SessionSender sender;
    private long createTime = System.currentTimeMillis();
    private long lastHeartbeatTime = System.currentTimeMillis();
    private long isolateTime = 0L;
    private SessionContext sessionContext = new SessionContext(this);
    private boolean listenRspSend = false;
    private ReentrantLock listenRspLock = new ReentrantLock();
    private String listenRequestSeq = null;
    protected SessionState sessionState = SessionState.CREATED;

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public long getLastHeartbeatTime() {
        return this.lastHeartbeatTime;
    }

    public void notifyHeartbeat(long heartbeatTime) throws Exception {
        this.lastHeartbeatTime = heartbeatTime;
    }

    public SessionState getSessionState() {
        return this.sessionState;
    }

    public void setSessionState(SessionState sessionState) {
        this.sessionState = sessionState;
    }

    public void setClient(UserAgent client) {
        this.client = client;
    }

    public SessionPusher getPusher() {
        return this.pusher;
    }

    public void setPusher(SessionPusher pusher) {
        this.pusher = pusher;
    }

    public SessionSender getSender() {
        return this.sender;
    }

    public void setSender(SessionSender sender) {
        this.sender = sender;
    }

    public void setLastHeartbeatTime(long lastHeartbeatTime) {
        this.lastHeartbeatTime = lastHeartbeatTime;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public ChannelHandlerContext getContext() {
        return this.context;
    }

    public void setContext(ChannelHandlerContext context) {
        this.context = context;
    }

    public UserAgent getClient() {
        return this.client;
    }

    public String getListenRequestSeq() {
        return this.listenRequestSeq;
    }

    public void setListenRequestSeq(String listenRequestSeq) {
        this.listenRequestSeq = listenRequestSeq;
    }

    public void subscribe(List<SubscriptionItem> items) throws Exception {
        for (SubscriptionItem item : items) {
            this.sessionContext.subscribeTopics.putIfAbsent(item.getTopic(), item);
            Objects.requireNonNull((ClientGroupWrapper)this.clientGroupWrapper.get()).subscribe(item);
            Objects.requireNonNull((ClientGroupWrapper)this.clientGroupWrapper.get()).getMqProducerWrapper().getMeshMQProducer().checkTopicExist(item.getTopic());
            Objects.requireNonNull((ClientGroupWrapper)this.clientGroupWrapper.get()).addSubscription(item, this);
            this.subscribeLogger.info("subscribe|succeed|topic={}|user={}", (Object)item.getTopic(), (Object)this.client);
        }
    }

    public void unsubscribe(List<SubscriptionItem> items) throws Exception {
        for (SubscriptionItem item : items) {
            this.sessionContext.subscribeTopics.remove(item.getTopic());
            Objects.requireNonNull((ClientGroupWrapper)this.clientGroupWrapper.get()).removeSubscription(item, this);
            if (Objects.requireNonNull((ClientGroupWrapper)this.clientGroupWrapper.get()).hasSubscription(item.getTopic())) continue;
            Objects.requireNonNull((ClientGroupWrapper)this.clientGroupWrapper.get()).unsubscribe(item);
            this.subscribeLogger.info("unSubscribe|succeed|topic={}|lastUser={}", (Object)item.getTopic(), (Object)this.client);
        }
    }

    public EventMeshTcpSendResult upstreamMsg(Header header, CloudEvent event, SendCallback sendCallback, long startTime, long taskExecuteTime) {
        String topic = event.getSubject();
        this.sessionContext.sendTopics.putIfAbsent(topic, topic);
        return this.sender.send(header, event, sendCallback, startTime, taskExecuteTime);
    }

    public void downstreamMsg(DownStreamMsgContext downStreamMsgContext) {
        long currTime = System.currentTimeMillis();
        this.trySendListenResponse(new Header(Command.LISTEN_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), "succeed", this.getListenRequestSeq()), currTime, currTime);
        this.pusher.push(downStreamMsgContext);
    }

    public boolean isIsolated() {
        return System.currentTimeMillis() < this.isolateTime;
    }

    public void write2Client(final Package pkg) {
        try {
            if (SessionState.CLOSED.equals((Object)this.sessionState)) {
                return;
            }
            this.context.writeAndFlush((Object)pkg).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        Session.this.messageLogger.error("write2Client fail, pkg[{}] session[{}]", (Object)pkg, (Object)this);
                    } else {
                        Objects.requireNonNull((ClientGroupWrapper)Session.this.clientGroupWrapper.get()).getEventMeshTcpMonitor().getTcpSummaryMetrics().getEventMesh2clientMsgNum().incrementAndGet();
                    }
                }
            });
        }
        catch (Exception e) {
            this.logger.error("exception while write2Client", (Throwable)e);
        }
    }

    public String toString() {
        return "Session{sysId=" + Objects.requireNonNull((ClientGroupWrapper)this.clientGroupWrapper.get()).getSysId() + ",remoteAddr=" + RemotingHelper.parseSocketAddressAddr(this.remoteAddress) + ",client=" + this.client + ",sessionState=" + this.sessionState + ",sessionContext=" + this.sessionContext + ",pusher=" + this.pusher + ",sender=" + this.sender + ",createTime=" + DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + ",lastHeartbeatTime=" + DateFormatUtils.format((long)this.lastHeartbeatTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        if (!Objects.equals(this.client, session.client)) {
            return false;
        }
        if (!Objects.equals(this.context, session.context)) {
            return false;
        }
        return Objects.equals((Object)this.sessionState, (Object)session.sessionState);
    }

    public WeakReference<ClientGroupWrapper> getClientGroupWrapper() {
        return this.clientGroupWrapper;
    }

    public void setClientGroupWrapper(WeakReference<ClientGroupWrapper> clientGroupWrapper) {
        this.clientGroupWrapper = clientGroupWrapper;
    }

    public Session(UserAgent client, ChannelHandlerContext context, EventMeshTCPConfiguration eventMeshTCPConfiguration) {
        this.client = client;
        this.context = context;
        this.eventMeshTCPConfiguration = eventMeshTCPConfiguration;
        this.remoteAddress = (InetSocketAddress)context.channel().remoteAddress();
        this.sender = new SessionSender(this);
        this.pusher = new SessionPusher(this);
    }

    public EventMeshTCPConfiguration getEventMeshTCPConfiguration() {
        return this.eventMeshTCPConfiguration;
    }

    public void setEventMeshTCPConfiguration(EventMeshTCPConfiguration eventMeshTCPConfiguration) {
        this.eventMeshTCPConfiguration = eventMeshTCPConfiguration;
    }

    public void trySendListenResponse(Header header, long startTime, long taskExecuteTime) {
        if (!this.listenRspSend && this.listenRspLock.tryLock()) {
            if (!this.listenRspSend) {
                if (header == null) {
                    header = new Header(Command.LISTEN_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), "succeed", null);
                }
                Package msg = new Package();
                msg.setHeader(header);
                Utils.writeAndFlush(msg, startTime, taskExecuteTime, this.context, this);
                this.listenRspSend = true;
            }
            this.listenRspLock.unlock();
        }
    }

    public long getIsolateTime() {
        return this.isolateTime;
    }

    public void setIsolateTime(long isolateTime) {
        this.isolateTime = isolateTime;
    }

    public boolean isAvailable(String topic) {
        if (SessionState.CLOSED == this.sessionState) {
            this.logger.warn("session is not available because session has been closed,topic:{},client:{}", (Object)topic, (Object)this.client);
            return false;
        }
        if (!this.sessionContext.subscribeTopics.containsKey(topic)) {
            this.logger.warn("session is not available because session has not subscribe topic:{},client:{}", (Object)topic, (Object)this.client);
            return false;
        }
        return true;
    }

    public boolean isRunning() {
        if (SessionState.RUNNING != this.sessionState) {
            this.logger.warn("session is not running, state:{} client:{}", (Object)this.sessionState, (Object)this.client);
            return false;
        }
        return true;
    }
}

