/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.push;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPClientPool {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<CloseableHttpClient> clients = Collections.synchronizedList(new ArrayList());
    private int core = 1;

    public HTTPClientPool(int core) {
        this.core = core;
    }

    public CloseableHttpClient getClient() {
        if (CollectionUtils.size(this.clients) < this.core) {
            CloseableHttpClient client = this.getHttpClient(200, 30, null);
            this.clients.add(client);
            return client;
        }
        return this.clients.get(RandomUtils.nextInt((int)this.core, (int)(2 * this.core)) % this.core);
    }

    public void shutdown() throws Exception {
        Iterator<CloseableHttpClient> itr = this.clients.iterator();
        while (itr.hasNext()) {
            CloseableHttpClient client = itr.next();
            client.close();
            itr.remove();
        }
    }

    public CloseableHttpClient getHttpClient(int maxTotal, int idleTimeInSeconds, SSLContext sslContext) {
        try {
            if (sslContext == null) {
                sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TheTrustStrategy()).build();
            }
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            this.logger.error("Get sslContext error: {}", (Object)e.getMessage());
            return HttpClients.createDefault();
        }
        X509HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setDefaultMaxPerRoute(maxTotal);
        connectionManager.setMaxTotal(maxTotal);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy()).evictIdleConnections((long)idleTimeInSeconds, TimeUnit.SECONDS).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy()).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler()).build();
    }

    public static class TheTrustStrategy
    implements TrustStrategy {
        public boolean isTrusted(X509Certificate[] arg0, String arg1) {
            return true;
        }
    }
}

