/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.service;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.protocol.grpc.protos.BatchMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.PublisherServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.protos.Response;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.BatchPublishMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.RequestMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.SendAsyncMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerService
extends PublisherServiceGrpc.PublisherServiceImplBase {
    private final Logger logger = LoggerFactory.getLogger(ProducerService.class);
    private final Logger cmdLogger = LoggerFactory.getLogger((String)"cmd");
    private final EventMeshGrpcServer eventMeshGrpcServer;
    private final ThreadPoolExecutor threadPoolExecutor;

    public ProducerService(EventMeshGrpcServer eventMeshGrpcServer, ThreadPoolExecutor threadPoolExecutor) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void publish(SimpleMessage request, StreamObserver<Response> responseObserver) {
        this.cmdLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"AsyncPublish", "grpc", request.getHeader().getIp(), this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().eventMeshIp});
        this.eventMeshGrpcServer.getMetricsMonitor().recordReceiveMsgFromClient();
        EventEmitter<Response> emitter = new EventEmitter<Response>(responseObserver);
        this.threadPoolExecutor.submit(() -> {
            SendAsyncMessageProcessor sendAsyncMessageProcessor = new SendAsyncMessageProcessor(this.eventMeshGrpcServer);
            try {
                sendAsyncMessageProcessor.process(request, emitter);
            }
            catch (Exception e) {
                this.logger.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getRetCode(), StatusCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getErrMsg(), e});
                ServiceUtils.sendRespAndDone(StatusCode.EVENTMESH_SEND_ASYNC_MSG_ERR, e.getMessage(), emitter);
            }
        });
    }

    public void requestReply(SimpleMessage request, StreamObserver<SimpleMessage> responseObserver) {
        this.cmdLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"RequestReply", "grpc", request.getHeader().getIp(), this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().eventMeshIp});
        this.eventMeshGrpcServer.getMetricsMonitor().recordReceiveMsgFromClient();
        EventEmitter<SimpleMessage> emitter = new EventEmitter<SimpleMessage>(responseObserver);
        this.threadPoolExecutor.submit(() -> {
            RequestMessageProcessor requestMessageProcessor = new RequestMessageProcessor(this.eventMeshGrpcServer);
            try {
                requestMessageProcessor.process(request, emitter);
            }
            catch (Exception e) {
                this.logger.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_REQUEST_REPLY_MSG_ERR.getRetCode(), StatusCode.EVENTMESH_REQUEST_REPLY_MSG_ERR.getErrMsg(), e});
                ServiceUtils.sendStreamRespAndDone(request.getHeader(), StatusCode.EVENTMESH_REQUEST_REPLY_MSG_ERR, e.getMessage(), emitter);
            }
        });
    }

    public void batchPublish(BatchMessage request, StreamObserver<Response> responseObserver) {
        this.cmdLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"BatchPublish", "grpc", request.getHeader().getIp(), this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().eventMeshIp});
        this.eventMeshGrpcServer.getMetricsMonitor().recordReceiveMsgFromClient(request.getMessageItemCount());
        EventEmitter<Response> emitter = new EventEmitter<Response>(responseObserver);
        this.threadPoolExecutor.submit(() -> {
            BatchPublishMessageProcessor batchPublishMessageProcessor = new BatchPublishMessageProcessor(this.eventMeshGrpcServer);
            try {
                batchPublishMessageProcessor.process(request, emitter);
            }
            catch (Exception e) {
                this.logger.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_BATCH_PUBLISH_ERR.getRetCode(), StatusCode.EVENTMESH_BATCH_PUBLISH_ERR.getErrMsg(), e});
                ServiceUtils.sendRespAndDone(StatusCode.EVENTMESH_BATCH_PUBLISH_ERR, e.getMessage(), emitter);
            }
        });
    }
}

