/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup;

import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.GrpcType;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.StreamTopicConfig;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.WebhookTopicConfig;

public abstract class ConsumerGroupTopicConfig {
    protected final String consumerGroup;
    protected final String topic;
    protected final Subscription.SubscriptionItem.SubscriptionMode subscriptionMode;
    protected final GrpcType grpcType;

    protected ConsumerGroupTopicConfig(String consumerGroup, String topic, Subscription.SubscriptionItem.SubscriptionMode subscriptionMode, GrpcType grpcType) {
        this.consumerGroup = consumerGroup;
        this.topic = topic;
        this.subscriptionMode = subscriptionMode;
        this.grpcType = grpcType;
    }

    public static ConsumerGroupTopicConfig buildTopicConfig(String consumerGroup, String topic, Subscription.SubscriptionItem.SubscriptionMode subscriptionMode, GrpcType grpcType) {
        if (GrpcType.STREAM.equals((Object)grpcType)) {
            return new StreamTopicConfig(consumerGroup, topic, subscriptionMode);
        }
        return new WebhookTopicConfig(consumerGroup, topic, subscriptionMode);
    }

    public abstract void registerClient(ConsumerGroupClient var1);

    public abstract void deregisterClient(ConsumerGroupClient var1);

    public abstract int getSize();

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public String getTopic() {
        return this.topic;
    }

    public Subscription.SubscriptionItem.SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public GrpcType getGrpcType() {
        return this.grpcType;
    }
}

