/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.runtime.boot.EventMeshBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;
import org.apache.eventmesh.runtime.registry.Registry;

public class EventMeshTcpBootstrap
implements EventMeshBootstrap {
    private EventMeshTCPServer eventMeshTcpServer;
    private final EventMeshTCPConfiguration eventMeshTcpConfiguration;
    private final EventMeshServer eventMeshServer;
    private final Registry registry;

    public EventMeshTcpBootstrap(EventMeshServer eventMeshServer, ConfigurationWrapper configurationWrapper, Registry registry) {
        this.eventMeshServer = eventMeshServer;
        this.registry = registry;
        this.eventMeshTcpConfiguration = new EventMeshTCPConfiguration(configurationWrapper);
        this.eventMeshTcpConfiguration.init();
        ConfigurationContextUtil.putIfAbsent((String)"TCP", (CommonConfiguration)this.eventMeshTcpConfiguration);
    }

    @Override
    public void init() throws Exception {
        if (this.eventMeshTcpConfiguration != null) {
            this.eventMeshTcpServer = new EventMeshTCPServer(this.eventMeshServer, this.eventMeshTcpConfiguration, this.registry);
            this.eventMeshTcpServer.init();
        }
    }

    @Override
    public void start() throws Exception {
        if (this.eventMeshTcpConfiguration != null) {
            this.eventMeshTcpServer.start();
        }
    }

    @Override
    public void shutdown() throws Exception {
        if (this.eventMeshTcpConfiguration != null) {
            this.eventMeshTcpServer.shutdown();
        }
    }
}

