/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshHttpBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshTcpBootstrap;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.connector.ConnectorResource;
import org.apache.eventmesh.runtime.registry.Registry;
import org.apache.eventmesh.runtime.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshServer {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Acl acl;
    private Registry registry;
    private static Trace trace;
    private final ConnectorResource connectorResource;
    private ServiceState serviceState;
    private final CommonConfiguration configuration;
    private static final List<EventMeshBootstrap> BOOTSTRAP_LIST;

    public EventMeshServer(ConfigurationWrapper configurationWrapper) {
        CommonConfiguration configuration = new CommonConfiguration(configurationWrapper);
        configuration.init();
        this.configuration = configuration;
        this.acl = new Acl();
        this.registry = new Registry();
        trace = new Trace(configuration.eventMeshServerTraceEnable);
        this.connectorResource = new ConnectorResource();
        List provideServerProtocols = configuration.eventMeshProvideServerProtocols;
        for (String provideServerProtocol : provideServerProtocols) {
            if ("HTTP".equals(provideServerProtocol)) {
                BOOTSTRAP_LIST.add(new EventMeshHttpBootstrap(this, configurationWrapper, this.registry));
            }
            if ("TCP".equals(provideServerProtocol)) {
                BOOTSTRAP_LIST.add(new EventMeshTcpBootstrap(this, configurationWrapper, this.registry));
            }
            if (!"GRPC".equals(provideServerProtocol)) continue;
            BOOTSTRAP_LIST.add(new EventMeshGrpcBootstrap(configurationWrapper, this.registry));
        }
    }

    public void init() throws Exception {
        if (this.configuration != null && this.configuration.eventMeshServerSecurityEnable) {
            this.acl.init(this.configuration.eventMeshSecurityPluginType);
        }
        if (this.configuration != null && this.configuration.eventMeshServerRegistryEnable) {
            this.registry.init(this.configuration.eventMeshRegistryPluginType);
        }
        if (this.configuration != null && this.configuration.eventMeshServerTraceEnable) {
            trace.init(this.configuration.eventMeshTracePluginType);
        }
        if (this.configuration != null) {
            this.connectorResource.init(this.configuration.eventMeshConnectorPluginType);
        }
        for (EventMeshBootstrap eventMeshBootstrap : BOOTSTRAP_LIST) {
            eventMeshBootstrap.init();
        }
        String eventStore = System.getProperty("eventstore", System.getenv("EVENT_STORE"));
        this.logger.info("eventStore : {}", (Object)eventStore);
        this.serviceState = ServiceState.INITED;
        this.logger.info("server state:{}", (Object)this.serviceState);
    }

    public void start() throws Exception {
        if (this.configuration != null && this.configuration.eventMeshServerSecurityEnable) {
            this.acl.start();
        }
        if (this.configuration != null && this.configuration.eventMeshServerRegistryEnable) {
            this.registry.start();
        }
        for (EventMeshBootstrap eventMeshBootstrap : BOOTSTRAP_LIST) {
            eventMeshBootstrap.start();
        }
        this.serviceState = ServiceState.RUNNING;
        this.logger.info("server state:{}", (Object)this.serviceState);
    }

    public void shutdown() throws Exception {
        this.serviceState = ServiceState.STOPING;
        this.logger.info("server state:{}", (Object)this.serviceState);
        for (EventMeshBootstrap eventMeshBootstrap : BOOTSTRAP_LIST) {
            eventMeshBootstrap.shutdown();
        }
        if (this.configuration != null && this.configuration.eventMeshServerRegistryEnable) {
            this.registry.shutdown();
        }
        this.connectorResource.release();
        if (this.configuration != null && this.configuration.eventMeshServerSecurityEnable) {
            this.acl.shutdown();
        }
        if (this.configuration != null && this.configuration.eventMeshServerTraceEnable) {
            trace.shutdown();
        }
        ConfigurationContextUtil.clear();
        this.serviceState = ServiceState.STOPED;
        this.logger.info("server state:{}", (Object)this.serviceState);
    }

    public static Trace getTrace() {
        return trace;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    static {
        BOOTSTRAP_LIST = new CopyOnWriteArrayList<EventMeshBootstrap>();
    }
}

