/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.util.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectAllClientHandler
implements HttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(RejectAllClientHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public RejectAllClientHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        String result = "";
        OutputStream out = httpExchange.getResponseBody();
        try {
            ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
            ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
            ArrayList<InetSocketAddress> successRemoteAddrs = new ArrayList<InetSocketAddress>();
            try {
                logger.info("rejectAllClient in admin====================");
                if (!sessionMap.isEmpty()) {
                    for (Map.Entry<InetSocketAddress, Session> entry : sessionMap.entrySet()) {
                        InetSocketAddress addr = EventMeshTcp2Client.serverGoodby2Client(this.eventMeshTCPServer, entry.getValue(), clientSessionGroupMapping);
                        if (addr == null) continue;
                        successRemoteAddrs.add(addr);
                    }
                }
            }
            catch (Exception e) {
                logger.error("clientManage|rejectAllClient|fail", (Throwable)e);
                result = String.format("rejectAllClient fail! sessionMap size {%d}, had reject {%s}, errorMsg : %s", sessionMap.size(), NetUtils.addressToString(successRemoteAddrs), e.getMessage());
                httpExchange.sendResponseHeaders(200, 0L);
                out.write(result.getBytes(Constants.DEFAULT_CHARSET));
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        logger.warn("out close failed...", (Throwable)e2);
                    }
                }
                return;
            }
            result = String.format("rejectAllClient success! sessionMap size {%d}, had reject {%s}", sessionMap.size(), NetUtils.addressToString(successRemoteAddrs));
            httpExchange.sendResponseHeaders(200, 0L);
            out.write(result.getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            logger.error("rejectAllClient fail...", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.warn("out close failed...", (Throwable)e);
                }
            }
        }
    }
}

