/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server.flowcontrol;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.Clock;
import com.navercorp.pinpoint.common.util.SystemClock;
import com.navercorp.pinpoint.grpc.server.flowcontrol.IdleTimeout;
import java.util.Objects;

public class DefaultIdleTimeout
implements IdleTimeout {
    private final long idleTimeout;
    private volatile long lastExecutionTime = Long.MAX_VALUE;
    private volatile boolean expired = false;
    private final Clock clock;

    public DefaultIdleTimeout(long idleTimeout) {
        this(idleTimeout, SystemClock.INSTANCE);
    }

    public DefaultIdleTimeout(long idleTimeout, Clock clock) {
        Assert.isTrue((idleTimeout >= 0L ? 1 : 0) != 0, (String)"negative idleTimeout");
        this.idleTimeout = idleTimeout;
        this.clock = Objects.requireNonNull(clock, "clock");
        this.update();
    }

    @Override
    public void update() {
        this.lastExecutionTime = this.clock.getTime();
    }

    @Override
    public boolean isExpired() {
        boolean result;
        if (this.expired) {
            return true;
        }
        long elapsedTime = this.clock.getTime() - this.lastExecutionTime;
        boolean bl = result = elapsedTime >= this.idleTimeout;
        if (result) {
            this.expired = true;
        }
        return result;
    }
}

