/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.navercorp.pinpoint.profiler.sender.grpc.ExponentialBackoffReconnectJob;
import com.navercorp.pinpoint.profiler.sender.grpc.ReconnectAdaptor;
import com.navercorp.pinpoint.profiler.sender.grpc.ReconnectJob;
import com.navercorp.pinpoint.profiler.sender.grpc.Reconnector;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReconnectExecutor {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private volatile boolean shutdown;
    private final ScheduledExecutorService scheduledExecutorService;
    private final AtomicLong rejectedCounter = new AtomicLong();

    public ReconnectExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = Objects.requireNonNull(scheduledExecutorService, "scheduledExecutorService");
    }

    private void execute0(Runnable command) {
        Objects.requireNonNull(command, "command");
        if (this.shutdown) {
            this.logger.debug("already shutdown");
            return;
        }
        if (command instanceof ReconnectJob) {
            ReconnectJob reconnectJob = (ReconnectJob)command;
            try {
                this.scheduledExecutorService.schedule(reconnectJob, reconnectJob.nextBackoffNanos(), TimeUnit.NANOSECONDS);
            }
            catch (RejectedExecutionException e) {
                long failCount = this.rejectedCounter.incrementAndGet();
                this.logger.info("{} reconnectJob scheduled fail {}", (Object)command, (Object)failCount);
            }
        } else {
            throw new IllegalArgumentException("unknown command type " + command);
        }
    }

    public void close() {
        this.shutdown = true;
    }

    public Reconnector newReconnector(Runnable reconnectJob) {
        Objects.requireNonNull(reconnectJob, "reconnectJob");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("newReconnector({})", (Object)reconnectJob);
        }
        Executor dispatch = new Executor(){

            @Override
            public void execute(Runnable command) {
                ReconnectExecutor.this.execute0(command);
            }
        };
        ReconnectJob reconnectJobWrap = this.wrapReconnectJob(reconnectJob);
        return new ReconnectAdaptor(dispatch, reconnectJobWrap);
    }

    private ReconnectJob wrapReconnectJob(Runnable runnable) {
        return new ExponentialBackoffReconnectJob(runnable);
    }
}

