/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin.filter;

import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import com.navercorp.pinpoint.profiler.plugin.PluginJar;
import com.navercorp.pinpoint.profiler.plugin.filter.PluginFilter;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JavaVersionFilter
implements PluginFilter {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final JvmVersion jvmVersion;

    public JavaVersionFilter() {
        this(JvmUtils.getVersion());
    }

    public JavaVersionFilter(JvmVersion jvmVersion) {
        this.jvmVersion = Objects.requireNonNull(jvmVersion, "jvmVersion");
    }

    @Override
    public boolean accept(PluginJar pluginJar) {
        String pluginId = pluginJar.getPluginId();
        if (pluginId == null) {
            this.logger.warn("Invalid plugin : {}, missing manifest entry : {}", (Object)pluginJar.getJarFile().getName(), (Object)"Pinpoint-Plugin-Id");
            return false;
        }
        String pluginCompilerVersion = pluginJar.getPluginCompilerVersion();
        if (pluginCompilerVersion == null) {
            this.logger.info("Skipping {} due to missing manifest entry : {}", (Object)pluginJar.getJarFile().getName(), (Object)"Pinpoint-Plugin-Compiler-Version");
            return false;
        }
        JvmVersion pluginJvmVersion = JvmVersion.getFromVersion((String)pluginCompilerVersion);
        if (pluginJvmVersion == JvmVersion.UNSUPPORTED) {
            this.logger.info("Skipping {} due to unknown plugin compiler version : {}", (Object)pluginId, (Object)pluginCompilerVersion);
            return false;
        }
        if (this.jvmVersion.onOrAfter(pluginJvmVersion)) {
            return true;
        }
        this.logger.info("Skipping {} due to java version. Required : {}, found : {}", (Object)pluginId, (Object)pluginJvmVersion, (Object)this.jvmVersion);
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JavaVersionFilter{");
        sb.append("jvmVersion=").append(this.jvmVersion);
        sb.append('}');
        return sb.toString();
    }
}

