/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.lambda;

import com.navercorp.pinpoint.bootstrap.instrument.lambda.LambdaBytecodeHandler;
import com.navercorp.pinpoint.bootstrap.module.ClassFileTransformModuleAdaptor;
import com.navercorp.pinpoint.bootstrap.module.JavaModuleFactory;
import java.security.ProtectionDomain;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;

public class DefaultLambdaBytecodeHandler
implements LambdaBytecodeHandler {
    private final JavaModuleFactory javaModuleFactory;
    private final ClassFileTransformModuleAdaptor classFileTransformer;

    public DefaultLambdaBytecodeHandler(ClassFileTransformModuleAdaptor classFileTransformer, JavaModuleFactory javaModuleFactory) {
        this.classFileTransformer = Objects.requireNonNull(classFileTransformer, "classFileTransformer");
        this.javaModuleFactory = Objects.requireNonNull(javaModuleFactory, "javaModuleFactory");
    }

    public byte[] handleLambdaBytecode(Class<?> hostClass, byte[] data, Object[] cpPatches) {
        try {
            ClassLoader classLoader = hostClass.getClassLoader();
            Object module = this.javaModuleFactory.getModule(hostClass);
            ProtectionDomain protectionDomain = hostClass.getProtectionDomain();
            byte[] transform = this.classFileTransformer.transform(module, classLoader, null, null, protectionDomain, data);
            if (transform != null) {
                return transform;
            }
            return data;
        }
        catch (Exception e) {
            LogManager.getLogger(this.getClass()).warn("lambda transform fail Caused by:" + e.getMessage(), (Throwable)e);
            return data;
        }
    }
}

