/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.classloading;

import com.navercorp.pinpoint.common.profiler.concurrent.jsr166.ConcurrentWeakHashMap;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import com.navercorp.pinpoint.profiler.instrument.classloading.DefineClassFactory;
import com.navercorp.pinpoint.profiler.instrument.classreading.SimpleClassMetadata;
import com.navercorp.pinpoint.profiler.instrument.classreading.SimpleClassMetadataReader;
import com.navercorp.pinpoint.profiler.plugin.ClassLoadingChecker;
import com.navercorp.pinpoint.profiler.plugin.PluginConfig;
import com.navercorp.pinpoint.profiler.util.ExtensionFilter;
import com.navercorp.pinpoint.profiler.util.FileBinary;
import com.navercorp.pinpoint.profiler.util.JarReader;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlainClassLoaderHandler
implements ClassInjector {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final JarReader pluginJarReader;
    private static final ConcurrentMap<ClassLoader, ClassLoaderAttachment> classLoaderAttachment = new ConcurrentWeakHashMap();
    private final PluginConfig pluginConfig;

    public PlainClassLoaderHandler(PluginConfig pluginConfig) {
        this.pluginConfig = Objects.requireNonNull(pluginConfig, "pluginConfig");
        this.pluginJarReader = new JarReader(pluginConfig.getPluginJarFile());
    }

    @Override
    public <T> Class<? extends T> injectClass(ClassLoader classLoader, String className) {
        if (classLoader == Object.class.getClassLoader()) {
            throw new IllegalStateException("BootStrapClassLoader");
        }
        try {
            if (!this.isPluginPackage(className)) {
                return this.loadClass(classLoader, className);
            }
            return this.injectClass0(classLoader, className);
        }
        catch (Exception e) {
            this.logger.warn("Failed to load plugin class {} with classLoader {}", (Object)className, (Object)classLoader, (Object)e);
            throw new PinpointException("Failed to load plugin class " + className + " with classLoader " + classLoader, (Throwable)e);
        }
    }

    @Override
    public InputStream getResourceAsStream(ClassLoader targetClassLoader, String internalName) {
        try {
            String name = JavaAssistUtils.jvmNameToJavaName(internalName);
            if (!this.isPluginPackage(name)) {
                return targetClassLoader.getResourceAsStream(internalName);
            }
            this.getClassLoaderAttachment(targetClassLoader, internalName);
            InputStream inputStream = this.getPluginInputStream(internalName);
            if (inputStream != null) {
                return inputStream;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("can not find resource : {} {} ", (Object)internalName, (Object)this.pluginConfig.getPluginJarURLExternalForm());
            }
            return targetClassLoader.getResourceAsStream(internalName);
        }
        catch (Exception e) {
            this.logger.warn("Failed to load plugin resource as stream {} with classLoader {}", (Object)internalName, (Object)targetClassLoader, (Object)e);
            return null;
        }
    }

    private boolean isPluginPackage(String className) {
        return this.pluginConfig.getPluginPackageFilter().accept(className);
    }

    private Class<?> injectClass0(ClassLoader classLoader, String className) throws IllegalArgumentException {
        String pluginJarPath;
        ClassLoaderAttachment attachment;
        Class<?> findClazz;
        if (this.isDebug) {
            this.logger.debug("Inject class className:{} cl:{}", (Object)className, (Object)classLoader);
        }
        if ((findClazz = (attachment = this.getClassLoaderAttachment(classLoader, pluginJarPath = this.pluginConfig.getPluginJarURLExternalForm())).getClass(className)) != null) {
            return findClazz;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("can not find class : {} {} ", (Object)className, (Object)this.pluginConfig.getPluginJarURLExternalForm());
        }
        return this.loadClass(classLoader, className);
    }

    private InputStream getPluginInputStream(String classPath) throws IllegalArgumentException {
        if (this.isDebug) {
            this.logger.debug("Get input stream className:{}", (Object)classPath);
        }
        try {
            return this.pluginJarReader.getInputStream(classPath);
        }
        catch (Exception ex) {
            if (this.isDebug) {
                this.logger.debug("Failed to read plugin jar: {}", (Object)this.pluginConfig.getPluginJarURLExternalForm(), (Object)ex);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoaderAttachment getClassLoaderAttachment(ClassLoader classLoader, String pluginJarPath) {
        PluginLock pluginLock;
        ClassLoaderAttachment attachment = this.getClassLoaderAttachment(classLoader);
        PluginLock pluginLock2 = pluginLock = attachment.getPluginLock(pluginJarPath);
        synchronized (pluginLock2) {
            if (!pluginLock.isLoaded()) {
                pluginLock.setLoaded();
                this.defineJarClass(classLoader, attachment);
            }
        }
        return attachment;
    }

    private ClassLoaderAttachment getClassLoaderAttachment(ClassLoader classLoader) {
        ClassLoaderAttachment exist = (ClassLoaderAttachment)classLoaderAttachment.get(classLoader);
        if (exist != null) {
            return exist;
        }
        ClassLoaderAttachment newInfo = new ClassLoaderAttachment();
        ClassLoaderAttachment old = classLoaderAttachment.putIfAbsent(classLoader, newInfo);
        if (old != null) {
            return old;
        }
        return newInfo;
    }

    private <T> Class<T> loadClass(ClassLoader classLoader, String className) {
        try {
            if (this.isDebug) {
                this.logger.debug("loadClass:{}", (Object)className);
            }
            if (classLoader == Object.class.getClassLoader()) {
                return Class.forName(className, false, classLoader);
            }
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            if (this.isDebug) {
                this.logger.debug("ClassNotFound {} cl:{}", (Object)ex.getMessage(), (Object)classLoader);
            }
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private void defineJarClass(ClassLoader classLoader, ClassLoaderAttachment attachment) {
        if (this.isDebug) {
            this.logger.debug("define Jar:{}", (Object)this.pluginConfig.getPluginJarURLExternalForm());
        }
        List<FileBinary> fileBinaryList = this.readJar();
        Map<String, SimpleClassMetadata> classEntryMap = this.parse(fileBinaryList);
        for (Map.Entry<String, SimpleClassMetadata> entry : classEntryMap.entrySet()) {
            SimpleClassMetadata classMetadata = entry.getValue();
            ClassLoadingChecker classLoadingChecker = new ClassLoadingChecker();
            classLoadingChecker.isFirstLoad(classMetadata.getClassName());
            this.define0(classLoader, attachment, classMetadata, classEntryMap, classLoadingChecker);
        }
    }

    private List<FileBinary> readJar() {
        try {
            return this.pluginJarReader.read(ExtensionFilter.CLASS_FILTER);
        }
        catch (IOException ex) {
            throw new RuntimeException(this.pluginConfig.getPluginJarURLExternalForm() + " read fail." + ex.getMessage(), ex);
        }
    }

    private Map<String, SimpleClassMetadata> parse(List<FileBinary> fileBinaryList) {
        HashMap<String, SimpleClassMetadata> parseMap = new HashMap<String, SimpleClassMetadata>();
        for (FileBinary fileBinary : fileBinaryList) {
            SimpleClassMetadata classNode = this.parseClass(fileBinary);
            parseMap.put(classNode.getClassName(), classNode);
        }
        return parseMap;
    }

    private SimpleClassMetadata parseClass(FileBinary fileBinary) {
        byte[] fileBinaryArray = fileBinary.getFileBinary();
        SimpleClassMetadata classMetadata = SimpleClassMetadataReader.readSimpleClassMetadata(fileBinaryArray);
        return classMetadata;
    }

    private void define0(ClassLoader classLoader, ClassLoaderAttachment attachment, SimpleClassMetadata currentClass, Map<String, SimpleClassMetadata> classMetaMap, ClassLoadingChecker classLoadingChecker) {
        if ("java.lang.Object".equals(currentClass.getClassName())) {
            return;
        }
        if (attachment.containsClass(currentClass.getClassName())) {
            return;
        }
        String superName = currentClass.getSuperClassName();
        if (this.isDebug) {
            this.logger.debug("className:{} super:{}", (Object)currentClass.getClassName(), (Object)superName);
        }
        if (!"java.lang.Object".equals(superName) && !this.isSkipClass(superName, classLoadingChecker)) {
            SimpleClassMetadata superClassBinary = classMetaMap.get(superName);
            if (this.isDebug) {
                this.logger.debug("superClass dependency define super:{} ori:{}", (Object)superClassBinary.getClassName(), (Object)currentClass.getClassName());
            }
            this.define0(classLoader, attachment, superClassBinary, classMetaMap, classLoadingChecker);
        }
        List<String> interfaceList = currentClass.getInterfaceNames();
        for (String interfaceName : interfaceList) {
            if (this.isSkipClass(interfaceName, classLoadingChecker)) continue;
            SimpleClassMetadata interfaceClassBinary = classMetaMap.get(interfaceName);
            if (interfaceClassBinary == null) {
                throw new PinpointException(interfaceName + " not found");
            }
            if (this.isDebug) {
                this.logger.debug("interface dependency define interface:{} ori:{}", (Object)interfaceClassBinary.getClassName(), (Object)interfaceClassBinary.getClassName());
            }
            this.define0(classLoader, attachment, interfaceClassBinary, classMetaMap, classLoadingChecker);
        }
        Class<?> clazz = this.defineClass(classLoader, currentClass);
        attachment.putClass(currentClass.getClassName(), clazz);
    }

    private Class<?> defineClass(ClassLoader classLoader, SimpleClassMetadata classMetadata) {
        if (this.isDebug) {
            this.logger.debug("define class:{} cl:{}", (Object)classMetadata.getClassName(), (Object)classLoader);
        }
        String className = classMetadata.getClassName();
        byte[] classBytes = classMetadata.getClassBinary();
        return DefineClassFactory.getDefineClass().defineClass(classLoader, className, classBytes);
    }

    private boolean isSkipClass(String className, ClassLoadingChecker classLoadingChecker) {
        if (!this.isPluginPackage(className)) {
            if (this.isDebug) {
                this.logger.debug("PluginFilter skip class:{}", (Object)className);
            }
            return true;
        }
        if (!classLoadingChecker.isFirstLoad(className)) {
            if (this.isDebug) {
                this.logger.debug("skip already loaded class:{}", (Object)className);
            }
            return true;
        }
        return false;
    }

    private static class PluginLock {
        private boolean loaded = false;

        private PluginLock() {
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public void setLoaded() {
            this.loaded = true;
        }
    }

    private class ClassLoaderAttachment {
        private final ConcurrentMap<String, PluginLock> pluginLock = new ConcurrentHashMap<String, PluginLock>();
        private final ConcurrentMap<String, Class<?>> classCache = new ConcurrentHashMap();

        private ClassLoaderAttachment() {
        }

        public PluginLock getPluginLock(String jarFile) {
            PluginLock exist = (PluginLock)this.pluginLock.get(jarFile);
            if (exist != null) {
                return exist;
            }
            PluginLock newPluginLock = new PluginLock();
            PluginLock old = this.pluginLock.putIfAbsent(jarFile, newPluginLock);
            if (old != null) {
                return old;
            }
            return newPluginLock;
        }

        public void putClass(String className, Class<?> clazz) {
            Class<?> duplicatedClass = this.classCache.putIfAbsent(className, clazz);
            if (duplicatedClass != null && PlainClassLoaderHandler.this.logger.isWarnEnabled()) {
                PlainClassLoaderHandler.this.logger.warn("duplicated pluginClass {}", (Object)className);
            }
        }

        public Class<?> getClass(String className) {
            return (Class)this.classCache.get(className);
        }

        public boolean containsClass(String className) {
            return this.classCache.containsKey(className);
        }
    }
}

