/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.knative.producer;

import io.cloudevents.CloudEvent;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.exception.ConnectorRuntimeException;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.connector.knative.cloudevent.KnativeMessageFactory;
import org.apache.eventmesh.connector.knative.producer.AbstractProducer;
import org.apache.eventmesh.connector.knative.utils.CloudEventUtils;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.asynchttpclient.util.HttpConstants;

public class ProducerImpl
extends AbstractProducer {
    public ProducerImpl(Properties properties) throws IOException {
        super(properties);
    }

    public Properties attributes() {
        return this.properties;
    }

    public void send(CloudEvent cloudEvent, SendCallback sendCallback) {
        try {
            ListenableFuture execute = ((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)super.getAsyncHttpClient().preparePost("http://" + this.attributes().getProperty("url")).addHeader((CharSequence)"Content-Type", cloudEvent.getDataContentType())).addHeader((CharSequence)"Ce-Id", cloudEvent.getId())).addHeader((CharSequence)"Ce-Specversion", String.valueOf(cloudEvent.getSpecVersion()))).addHeader((CharSequence)"Ce-Type", cloudEvent.getType())).addHeader((CharSequence)"Ce-Source", String.valueOf(cloudEvent.getSource()))).setBody(KnativeMessageFactory.createReader(cloudEvent))).execute();
            Response response = (Response)execute.get(10L, TimeUnit.SECONDS);
            if (response.getStatusCode() == HttpConstants.ResponseStatusCodes.OK_200) {
                sendCallback.onSuccess(CloudEventUtils.convertSendResult(cloudEvent));
                return;
            }
            throw new IllegalStateException("HTTP response code error: " + response.getStatusCode());
        }
        catch (Exception e) {
            ConnectorRuntimeException onsEx = this.checkProducerException(cloudEvent, e);
            OnExceptionContext context = new OnExceptionContext();
            context.setTopic(KnativeMessageFactory.createReader(cloudEvent));
            context.setException(onsEx);
            sendCallback.onException(context);
            return;
        }
    }

    public void sendAsync(CloudEvent cloudEvent, SendCallback sendCallback) {
        try {
            this.send(cloudEvent, sendCallback);
        }
        catch (Exception e) {
            logger.error(String.format("Send cloudevent message Exception, %s", e));
            throw new ConnectorRuntimeException("Send cloudevent message Exception.");
        }
    }

    public void init(Properties properties) throws Exception {
        new ProducerImpl(properties);
    }

    public void publish(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        this.sendAsync(cloudEvent, sendCallback);
    }

    public void sendOneway(CloudEvent cloudEvent) {
        throw new ConnectorRuntimeException("SendOneWay is not supported");
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) throws Exception {
        throw new ConnectorRuntimeException("Request is not supported");
    }

    public boolean reply(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        throw new ConnectorRuntimeException("Reply is not supported");
    }

    public void checkTopicExist(String topic) throws Exception {
        throw new ConnectorRuntimeException("CheckTopicExist is not supported");
    }

    public void setExtFields() {
        throw new ConnectorRuntimeException("SetExtFields is not supported");
    }

    public void start() {
        this.started.set(true);
    }

    public void shutdown() {
        this.started.set(false);
    }
}

