/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.sdk.metrics.AbstractInstrument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class InstrumentRegistry {
    private final ConcurrentMap<String, AbstractInstrument> registry = new ConcurrentHashMap<String, AbstractInstrument>();

    InstrumentRegistry() {
    }

    <I extends AbstractInstrument> I register(I instrument) {
        AbstractInstrument oldInstrument = this.registry.putIfAbsent(instrument.getDescriptor().getName().toLowerCase(), instrument);
        if (oldInstrument != null) {
            if (!instrument.getClass().isInstance(oldInstrument) || !instrument.equals(oldInstrument)) {
                throw new IllegalArgumentException("Instrument with same name and different descriptor already created.");
            }
            return (I)oldInstrument;
        }
        return instrument;
    }

    Collection<AbstractInstrument> getInstruments() {
        return Collections.unmodifiableCollection(new ArrayList(this.registry.values()));
    }
}

