/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.registry.zookeeper.service;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.eventmesh.api.exception.RegistryException;
import org.apache.eventmesh.api.registry.RegistryService;
import org.apache.eventmesh.api.registry.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.registry.zookeeper.pojo.EventMeshInstance;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperRegistryService
implements RegistryService {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperRegistryService.class);
    private static final AtomicBoolean INIT_STATUS = new AtomicBoolean(false);
    private static final AtomicBoolean START_STATUS = new AtomicBoolean(false);
    private String serverAddr;
    public CuratorFramework zkClient = null;
    private Map<String, EventMeshRegisterInfo> eventMeshRegisterInfoMap;

    public void init() throws RegistryException {
        boolean update = INIT_STATUS.compareAndSet(false, true);
        if (!update) {
            logger.warn("[ZookeeperRegistryService] has been init");
            return;
        }
        this.eventMeshRegisterInfoMap = new HashMap<String, EventMeshRegisterInfo>(ConfigurationContextUtil.KEYS.size());
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration commonConfiguration = ConfigurationContextUtil.get((String)key);
            if (null == commonConfiguration) continue;
            if (StringUtils.isBlank((CharSequence)commonConfiguration.namesrvAddr)) {
                throw new RegistryException("namesrvAddr cannot be null");
            }
            this.serverAddr = commonConfiguration.namesrvAddr;
            break;
        }
    }

    public void start() throws RegistryException {
        boolean update = START_STATUS.compareAndSet(false, true);
        if (!update) {
            logger.warn("[ZookeeperRegistryService] has been start");
            return;
        }
        try {
            ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 5);
            this.zkClient = CuratorFrameworkFactory.builder().connectString(this.serverAddr).retryPolicy((RetryPolicy)retryPolicy).namespace("eventmesh").build();
            this.zkClient.start();
        }
        catch (Exception e) {
            throw new RegistryException("ZookeeperRegistry starting failed", (Throwable)e);
        }
    }

    public void shutdown() throws RegistryException {
        INIT_STATUS.compareAndSet(true, false);
        START_STATUS.compareAndSet(true, false);
        try {
            CuratorFramework closedClient = this.zkClient;
            if (closedClient != null) {
                closedClient.close();
            }
        }
        catch (Exception e) {
            throw new RegistryException("ZookeeperRegistry shutdown failed", (Throwable)e);
        }
        logger.info("ZookeeperRegistryService closed");
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws RegistryException {
        ArrayList<EventMeshDataInfo> eventMeshDataInfoList = new ArrayList<EventMeshDataInfo>();
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration configuration = ConfigurationContextUtil.get((String)key);
            if (Objects.isNull(configuration)) continue;
            String eventMeshName = configuration.eventMeshName;
            try {
                String serviceName = eventMeshName.concat("-").concat(key);
                String servicePath = this.formatServicePath(clusterName, serviceName);
                List instances = (List)this.zkClient.getChildren().forPath(servicePath);
                if (CollectionUtils.isEmpty((Collection)instances)) continue;
                for (String endpoint : instances) {
                    byte[] data;
                    String instancePath = servicePath.concat("/").concat(endpoint);
                    Stat stat = new Stat();
                    try {
                        data = (byte[])((WatchPathable)this.zkClient.getData().storingStatIn(stat)).forPath(instancePath);
                    }
                    catch (Exception e) {
                        logger.warn("[ZookeeperRegistryService][findEventMeshInfoByCluster] failed for path: {}", (Object)instancePath, (Object)e);
                        continue;
                    }
                    EventMeshInstance eventMeshInstance = (EventMeshInstance)JsonUtils.deserialize((String)new String(data, StandardCharsets.UTF_8), EventMeshInstance.class);
                    EventMeshDataInfo eventMeshDataInfo = new EventMeshDataInfo(clusterName, serviceName, endpoint, stat.getMtime(), eventMeshInstance.getMetaData());
                    eventMeshDataInfoList.add(eventMeshDataInfo);
                }
            }
            catch (Exception e) {
                throw new RegistryException("ZookeeperRegistry findEventMeshInfoByCluster failed", (Throwable)e);
            }
        }
        return eventMeshDataInfoList;
    }

    public List<EventMeshDataInfo> findAllEventMeshInfo() throws RegistryException {
        ArrayList<EventMeshDataInfo> eventMeshDataInfoList = new ArrayList<EventMeshDataInfo>();
        for (Map.Entry<String, EventMeshRegisterInfo> entry : this.eventMeshRegisterInfoMap.entrySet()) {
            String serviceName = entry.getKey();
            String clusterName = entry.getValue().getEventMeshClusterName();
            try {
                String servicePath = this.formatServicePath(clusterName, serviceName);
                List instances = (List)this.zkClient.getChildren().forPath(servicePath);
                if (CollectionUtils.isEmpty((Collection)instances)) continue;
                for (String endpoint : instances) {
                    byte[] data;
                    String instancePath = servicePath.concat("/").concat(endpoint);
                    Stat stat = new Stat();
                    try {
                        data = (byte[])((WatchPathable)this.zkClient.getData().storingStatIn(stat)).forPath(instancePath);
                    }
                    catch (Exception e) {
                        logger.warn("[ZookeeperRegistryService][findAllEventMeshInfo] failed for path: {}", (Object)instancePath, (Object)e);
                        continue;
                    }
                    EventMeshInstance eventMeshInstance = (EventMeshInstance)JsonUtils.deserialize((String)new String(data, StandardCharsets.UTF_8), EventMeshInstance.class);
                    EventMeshDataInfo eventMeshDataInfo = new EventMeshDataInfo(clusterName, serviceName, endpoint, stat.getMtime(), eventMeshInstance.getMetaData());
                    eventMeshDataInfoList.add(eventMeshDataInfo);
                }
            }
            catch (Exception e) {
                throw new RegistryException("ZookeeperRegistry findAllEventMeshInfo failed", (Throwable)e);
            }
        }
        return eventMeshDataInfoList;
    }

    public Map<String, Map<String, Integer>> findEventMeshClientDistributionData(String clusterName, String group, String purpose) throws RegistryException {
        return null;
    }

    public void registerMetadata(Map<String, String> metadataMap) {
        for (Map.Entry<String, EventMeshRegisterInfo> eventMeshRegisterInfo : this.eventMeshRegisterInfoMap.entrySet()) {
            EventMeshRegisterInfo registerInfo = eventMeshRegisterInfo.getValue();
            registerInfo.setMetadata(metadataMap);
            this.register(registerInfo);
        }
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws RegistryException {
        try {
            String[] ipPort = eventMeshRegisterInfo.getEndPoint().split(":");
            String ip = ipPort[0];
            Integer port = Integer.valueOf(ipPort[1]);
            String eventMeshName = eventMeshRegisterInfo.getEventMeshName();
            String eventMeshClusterName = eventMeshRegisterInfo.getEventMeshClusterName();
            Map instanceNumMap = eventMeshRegisterInfo.getEventMeshInstanceNumMap();
            Map metadata = eventMeshRegisterInfo.getMetadata();
            EventMeshInstance eventMeshInstance = new EventMeshInstance();
            eventMeshInstance.setIp(ip);
            eventMeshInstance.setPort(port);
            eventMeshInstance.setInstanceNumMap(instanceNumMap);
            eventMeshInstance.setMetaData(metadata);
            String path = this.formatInstancePath(eventMeshClusterName, eventMeshName, eventMeshRegisterInfo.getEndPoint());
            ((ACLBackgroundPathAndBytesable)this.zkClient.create().orSetData().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path, JsonUtils.serialize((Object)eventMeshInstance).getBytes(StandardCharsets.UTF_8));
            this.eventMeshRegisterInfoMap.put(eventMeshName, eventMeshRegisterInfo);
        }
        catch (Exception e) {
            throw new RegistryException("ZookeeperRegistry register failed", (Throwable)e);
        }
        logger.info("EventMesh successfully registered to zookeeper");
        return true;
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws RegistryException {
        try {
            String eventMeshName = eventMeshUnRegisterInfo.getEventMeshName();
            String eventMeshClusterName = eventMeshUnRegisterInfo.getEventMeshClusterName();
            String path = this.formatInstancePath(eventMeshClusterName, eventMeshName, eventMeshUnRegisterInfo.getEndPoint());
            this.zkClient.delete().forPath(path);
        }
        catch (Exception e) {
            throw new RegistryException("ZookeeperRegistry unRegister failed", (Throwable)e);
        }
        logger.info("EventMesh successfully logout to zookeeper");
        return true;
    }

    private String formatInstancePath(String clusterName, String serviceName, String endPoint) {
        return "/".concat(clusterName).concat("/").concat(serviceName).concat("/").concat(endPoint);
    }

    private String formatServicePath(String clusterName, String serviceName) {
        return "/".concat(clusterName).concat("/").concat(serviceName);
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public CuratorFramework getZkClient() {
        return this.zkClient;
    }
}

