/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.trace.zipkin.config;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipkinConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ZipkinConfiguration.class);
    private static final String CONFIG_FILE = "zipkin.properties";
    private static final Properties properties = new Properties();
    private static String eventMeshZipkinIP = "localhost";
    private static int eventMeshZipkinPort = 9411;

    public static String getEventMeshZipkinIP() {
        return eventMeshZipkinIP;
    }

    public static int getEventMeshZipkinPort() {
        return eventMeshZipkinPort;
    }

    private static void initializeConfig() {
        String eventMeshZipkinIPStr = properties.getProperty("eventmesh.trace.zipkin.ip");
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)eventMeshZipkinIPStr), (Object)String.format("%s error", "eventmesh.trace.zipkin.ip"));
        eventMeshZipkinIP = StringUtils.deleteWhitespace((String)eventMeshZipkinIPStr);
        String eventMeshZipkinPortStr = properties.getProperty("eventmesh.trace.zipkin.port");
        if (StringUtils.isNotEmpty((CharSequence)eventMeshZipkinPortStr)) {
            eventMeshZipkinPort = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshZipkinPortStr));
        }
    }

    private static void loadProperties() {
        URL resource = ZipkinConfiguration.class.getClassLoader().getResource(CONFIG_FILE);
        if (resource != null) {
            try (InputStream inputStream = resource.openStream();){
                if (inputStream.available() > 0) {
                    properties.load(new BufferedReader(new InputStreamReader(inputStream)));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Load zipkin.properties file from classpath error");
            }
        }
        try {
            String configPath = Constants.EVENTMESH_CONF_HOME + File.separator + CONFIG_FILE;
            PropertiesUtils.loadPropertiesWhenFileExist((Properties)properties, (String)configPath);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load zipkin.properties file from conf");
        }
    }

    private ZipkinConfiguration() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        ZipkinConfiguration.loadProperties();
        ZipkinConfiguration.initializeConfig();
    }
}

