/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.apache.IntHashMap;
import java.util.EnumSet;
import java.util.Set;

public enum JvmVersion {
    JAVA_1(1.1f, 45),
    JAVA_2(1.2f, 46),
    JAVA_3(1.3f, 47),
    JAVA_4(1.4f, 48),
    JAVA_5(1.5f, 49),
    JAVA_6(1.6f, 50),
    JAVA_7(1.7f, 51),
    JAVA_8(1.8f, 52),
    JAVA_9(9.0f, 53),
    JAVA_10(10.0f, 54),
    JAVA_11(11.0f, 55),
    JAVA_12(12.0f, 56),
    JAVA_13(13.0f, 57),
    JAVA_14(14.0f, 58),
    JAVA_15(15.0f, 59),
    JAVA_16(16.0f, 60),
    JAVA_17(17.0f, 61),
    JAVA_RECENT(99.0f, 99),
    UNSUPPORTED(-1.0f, -1);

    private final float version;
    private final int classVersion;
    private static final Set<JvmVersion> JVM_VERSION;
    private static final IntHashMap<JvmVersion> CLASS_VERSION_MAP;

    private JvmVersion(float version, int classVersion) {
        this.version = version;
        this.classVersion = classVersion;
    }

    public int getClassVersion() {
        return this.classVersion;
    }

    public boolean onOrAfter(JvmVersion other) {
        if (this == UNSUPPORTED || other == UNSUPPORTED) {
            return false;
        }
        return this == other || this.version > other.version;
    }

    public static JvmVersion getFromVersion(String javaVersion) {
        try {
            float version = Float.parseFloat(javaVersion);
            return JvmVersion.getFromVersion(version);
        }
        catch (NumberFormatException e) {
            return UNSUPPORTED;
        }
    }

    public static JvmVersion getFromVersion(float javaVersion) {
        for (JvmVersion version : JVM_VERSION) {
            if (Float.compare(version.version, javaVersion) != 0) continue;
            return version;
        }
        if (JvmVersion.JAVA_1.version > javaVersion) {
            return UNSUPPORTED;
        }
        return JAVA_RECENT;
    }

    private static IntHashMap<JvmVersion> toClassVersionMap() {
        IntHashMap<JvmVersion> jvmVersionIntHashMap = new IntHashMap<JvmVersion>();
        for (JvmVersion version : JvmVersion.values()) {
            jvmVersionIntHashMap.put(version.classVersion, version);
        }
        return jvmVersionIntHashMap;
    }

    public static JvmVersion getFromClassVersion(int classVersion) {
        JvmVersion jvmVersion = CLASS_VERSION_MAP.get(classVersion);
        if (jvmVersion == null) {
            if (JvmVersion.JAVA_1.classVersion > classVersion) {
                return UNSUPPORTED;
            }
            return JAVA_RECENT;
        }
        return jvmVersion;
    }

    static {
        JVM_VERSION = EnumSet.allOf(JvmVersion.class);
        CLASS_VERSION_MAP = JvmVersion.toClassVersionMap();
    }
}

